/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public abstract class AbstractPrefPage
extends PreferencePage {
    private static final Log log = Log.getLog(AbstractPrefPage.class);
    private IObjectPropertyConfigurator<Object, Object> extConfigurator;

    protected Control createContents(Composite parent) {
        if (!this.hasAccessToPage()) {
            return UIUtils.createLabel(parent, UIMessages.preference_page_no_access);
        }
        Control content = this.createPreferenceContent(parent);
        Dialog.applyDialogFont((Control)content);
        return content;
    }

    void disableButtons() {
        this.noDefaultAndApplyButton();
    }

    @NotNull
    protected abstract Control createPreferenceContent(@NotNull Composite var1);

    protected boolean hasAccessToPage() {
        return true;
    }

    protected void restartWorkbenchOnPrefChange() {
        Runnable restarter = () -> {
            boolean bl = PlatformUI.getWorkbench().restart();
        };
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        if (iPreferencePageContainer instanceof Window) {
            Window window = (Window)iPreferencePageContainer;
            window.getShell().addDisposeListener(e -> UIUtils.asyncExec(restarter));
            window.close();
        } else {
            restarter.run();
        }
    }

    protected void performApply() {
        if (this.extConfigurator != null) {
            this.extConfigurator.saveSettings(this.getConfiguratorObject());
        }
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        if (this.extConfigurator != null) {
            this.extConfigurator.resetSettings(this.getConfiguratorObject());
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.extConfigurator != null) {
            this.extConfigurator.saveSettings(this.getConfiguratorObject());
        }
        return super.performOk();
    }

    protected Object getConfiguratorObject() {
        return this;
    }

    protected void injectConfigurators(Composite composite) {
        UIPropertyConfiguratorDescriptor configDesc = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(this.getConfiguratorObject());
        if (configDesc != null) {
            try {
                this.extConfigurator = configDesc.createConfigurator();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (this.extConfigurator != null) {
            this.extConfigurator.createControl(composite, this.getConfiguratorObject(), () -> {});
            this.extConfigurator.loadSettings(this.getConfiguratorObject());
        }
    }
}

