/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.util;

import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.util.MinifySheetHandler;
import io.sf.carte.doc.style.css.util.ShallowMinificationHandler;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenProducer;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.agent.AgentUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Minify {
    private static final int DEFAULT_BUFFER_SIZE = 256;

    public static void main(String[] args) throws URISyntaxException, IllegalArgumentException, IOException {
        int status = Minify.main(args, System.out, System.err);
        System.exit(status);
    }

    static int main(String[] args, PrintStream out, PrintStream err) throws URISyntaxException, IllegalArgumentException, IOException {
        ConfigImpl config;
        if (args == null || args.length == 0 || (config = Minify.readConfig(args)) == null) {
            Minify.printUsage(err);
            return 2;
        }
        StringBuilder buffer = new StringBuilder(256);
        try {
            Path filePath = Paths.get(config.path, new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                boolean ret = Minify.minifyCSS(filePath, (Config)config, buffer, err);
                out.print(buffer);
                return ret ? 0 : 1;
            }
        }
        catch (InvalidPathException filePath) {
            // empty catch block
        }
        URI uri = new URI(config.path);
        URL url = uri.toURL();
        boolean ret = Minify.minifyCSS(url, (Config)config, buffer, err);
        out.print(buffer);
        return ret ? 0 : 1;
    }

    private static void printUsage(PrintStream err) {
        err.println("Usage: " + Minify.class.getName() + " [--charset <charset>] [--disable-shorthand [<shorthand-list>]] [--preserve-comment-char \"<char>\"] [--validate] <style-sheet-uri-or-path>");
    }

    private static ConfigImpl readConfig(String[] args) {
        boolean enableShorthands = true;
        ConfigImpl config = new ConfigImpl();
        block2: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("--")) {
                if (config.path == null) {
                    config.path = arg;
                    continue;
                }
                return null;
            }
            if ("--charset".equalsIgnoreCase(arg)) {
                if (++i >= args.length) continue;
                arg = args[i];
                if (!arg.startsWith("--")) {
                    try {
                        config.encoding = Charset.forName(arg);
                        continue;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                --i;
                continue;
            }
            if ("--disable-shorthand".equalsIgnoreCase(arg)) {
                enableShorthands = false;
                if (++i >= args.length) continue;
                arg = args[i];
                if (!arg.startsWith("--")) {
                    arg = arg.toLowerCase(Locale.ROOT);
                    String[] shorthands = arg.split(",");
                    config.disabledShorthands = new HashSet(shorthands.length);
                    for (String shorthand : shorthands) {
                        if ("all".equals(shorthand)) {
                            config.disabledShorthands = null;
                            continue block2;
                        }
                        config.disabledShorthands.add(shorthand);
                    }
                    continue;
                }
                config.disabledShorthands = null;
                --i;
                continue;
            }
            if ("--preserve-comment-char".equalsIgnoreCase(arg)) {
                if (++i < args.length && (arg = args[i]).length() == 1) {
                    config.preserveCommentChar = arg.charAt(0);
                    continue;
                }
                return null;
            }
            if (!"--validate".equalsIgnoreCase(arg)) continue;
            config.validate = true;
        }
        if (config.path == null) {
            config = null;
        } else if (enableShorthands) {
            config.disabledShorthands = Collections.emptySet();
        }
        return config;
    }

    public static String minifyCSS(String css) {
        return Minify.minifyCSS(css, null, null);
    }

    public static String minifyCSS(String css, Config config, PrintStream err) {
        if (config == null) {
            config = new ConfigImpl();
        }
        BufferSimpleWriter wri = new BufferSimpleWriter(256);
        MinifySheetHandler handler = new MinifySheetHandler(wri, config);
        CSSParser parser = Minify.createCSSParser(config);
        parser.setDocumentHandler(handler);
        StringReader cssReader = new StringReader(css);
        try {
            parser.parseStyleSheet(cssReader);
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            Minify.printStackTraceIfNotNull(e, err);
            StringBuilder buffer = new StringBuilder(css.length());
            try {
                cssReader.reset();
                Minify.shallowMinify(cssReader, buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return buffer.toString();
        }
        return wri.toString();
    }

    private static CSSParser createCSSParser(Config config) {
        EnumSet<Parser.Flag> flags = EnumSet.of(Parser.Flag.IEPRIO, Parser.Flag.IEPRIOCHAR, Parser.Flag.IEVALUES, Parser.Flag.STARHACK);
        if (!config.validate()) {
            flags.add(Parser.Flag.DISABLE_VALUE_VALIDATION);
        }
        return new CSSOMParser(flags);
    }

    public static String minifyCSS(Path cssPath) throws IOException {
        StringBuilder builder = new StringBuilder(256);
        Minify.minifyCSS(cssPath, null, builder, null);
        return builder.toString();
    }

    public static boolean minifyCSS(Path cssPath, Config config, StringBuilder buffer) throws IOException {
        return Minify.minifyCSS(cssPath, config, buffer, null);
    }

    public static boolean minifyCSS(Path cssPath, Config config, StringBuilder buffer, PrintStream err) throws IOException {
        boolean bl;
        block16: {
            Charset encoding;
            if (config == null) {
                config = new ConfigImpl();
            }
            if ((encoding = config.getEncoding()) == null) {
                encoding = StandardCharsets.UTF_8;
            }
            BufferSimpleWriter wri = new BufferSimpleWriter(buffer);
            MinifySheetHandler handler = new MinifySheetHandler(wri, config);
            CSSParser parser = Minify.createCSSParser(config);
            parser.setDocumentHandler(handler);
            BufferedReader cssReader = Files.newBufferedReader(cssPath, encoding);
            try {
                parser.parseStyleSheet(cssReader);
                bl = true;
                if (cssReader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (cssReader != null) {
                        try {
                            cssReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Minify.printStackTraceIfNotNull(e, err);
                    buffer.setLength(0);
                    cssReader = Files.newBufferedReader(cssPath, encoding);
                    try {
                        Minify.shallowMinify(cssReader, buffer);
                    }
                    finally {
                        if (cssReader != null) {
                            ((Reader)cssReader).close();
                        }
                    }
                    return false;
                }
            }
            cssReader.close();
        }
        return bl;
    }

    public static boolean minifyCSS(URL url, Config config, StringBuilder buffer, PrintStream err) throws IOException {
        boolean bl;
        block16: {
            Charset encoding;
            if (config == null) {
                config = new ConfigImpl();
            }
            if ((encoding = config.getEncoding()) == null) {
                encoding = StandardCharsets.UTF_8;
            }
            BufferSimpleWriter wri = new BufferSimpleWriter(buffer);
            MinifySheetHandler handler = new MinifySheetHandler(wri, config);
            CSSParser parser = Minify.createCSSParser(config);
            parser.setDocumentHandler(handler);
            URLConnection ucon = url.openConnection();
            Reader cssReader = Minify.inputStreamToReader(ucon, encoding);
            try {
                parser.parseStyleSheet(cssReader);
                bl = true;
                if (cssReader == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (cssReader != null) {
                        try {
                            cssReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Minify.printStackTraceIfNotNull(e, err);
                    buffer.setLength(0);
                    ucon = url.openConnection();
                    cssReader = Minify.inputStreamToReader(ucon, encoding);
                    try {
                        Minify.shallowMinify(cssReader, buffer);
                    }
                    finally {
                        if (cssReader != null) {
                            cssReader.close();
                        }
                    }
                    return false;
                }
            }
            cssReader.close();
        }
        return bl;
    }

    private static void printStackTraceIfNotNull(Exception e, PrintStream err) {
        if (err != null) {
            e.printStackTrace(err);
        }
    }

    private static Reader inputStreamToReader(URLConnection ucon, Charset encoding) throws IOException {
        InputStream is = ucon.getInputStream();
        String contentEncoding = ucon.getContentEncoding();
        String conType = ucon.getContentType();
        return AgentUtil.inputStreamToReader((InputStream)is, (String)conType, (String)contentEncoding, (Charset)encoding);
    }

    public static void shallowMinify(Reader cssReader, StringBuilder buffer) throws IOException {
        Minify.shallowMinify(cssReader, null, buffer);
    }

    public static void shallowMinify(Reader cssReader, ShallowConfig config, StringBuilder buffer) throws IOException {
        if (config == null) {
            config = new ShallowConfig(){};
        }
        String opening = "/*";
        String closing = "*/";
        ShallowMinificationHandler h = new ShallowMinificationHandler(buffer, config);
        TokenProducer tp = new TokenProducer((TokenHandler2)h);
        tp.setHandleAllSeparators(false);
        tp.parse(cssReader, opening, closing);
    }

    private static class ConfigImpl
    implements Config {
        private Set<String> disabledShorthands = null;
        private Charset encoding;
        private char preserveCommentChar = (char)33;
        private boolean validate;
        private String path;

        private ConfigImpl() {
        }

        @Override
        public boolean isDisabledShorthand(String name) {
            return this.disabledShorthands == null || this.disabledShorthands.contains(name);
        }

        @Override
        public Charset getEncoding() {
            return this.encoding;
        }

        @Override
        public char getPreserveCommentChar() {
            return this.preserveCommentChar;
        }

        @Override
        public boolean validate() {
            return this.validate;
        }
    }

    public static interface Config
    extends ShallowConfig {
        default public Charset getEncoding() {
            return null;
        }

        default public boolean isDisabledShorthand(String name) {
            return false;
        }

        default public void serializeSelectors(SelectorList selectors, StringBuilder buffer) {
            buffer.append(selectors.toString());
        }

        default public void serializeValue(String property, String value, StringBuilder buffer) {
            buffer.append(value);
        }

        default public boolean validate() {
            return false;
        }
    }

    public static interface ShallowConfig {
        default public char getPreserveCommentChar() {
            return '!';
        }
    }
}

