---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'アプリケーションセキュリティテスト'
description: スキャン、脆弱性、コンプライアンス、カスタマイズ、レポート作成
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLabのアプリケーションセキュリティテスト機能を使用して、開発プロセスにセキュリティを組み込みます。これらの機能は、脆弱性が本番環境に到達する前に、開発ライフサイクルの早い段階で脆弱性を特定して、対処できるようにします。

GitLabのアプリケーションセキュリティテストでは、リポジトリコンテンツとデプロイ済みのアプリケーションの両方が包括的に網羅されるため、ソフトウェア開発ライフサイクル全体を通じて潜在的なセキュリティ問題を検出できます。

GitLabは、複数の保護メカニズムを通じて、脆弱性が持ち込まれるリスクを軽減するのにも役立ちます。

シークレットプッシュ保護: キーやAPIトークンなどのシークレットがGitLabにプッシュされるのをブロックします。

マージリクエスト承認ポリシー: 脆弱性をもたらす可能性のあるマージリクエストに追加の承認を強制します。

クリックスルーデモについては、[パイプラインにセキュリティを統合する](https://gitlab.navattic.com/gitlab-scans)を参照してください。
<!-- Demo published on 2024-01-15 -->

## アプリケーションセキュリティテストのしくみ {#how-application-security-testing-works}

GitLabは、コード、依存関係、コンテナ、およびデプロイ済みのアプリケーションすべてにわたってセキュリティの脆弱性を検出します。プロジェクトのリポジトリとアプリケーションの動作をスキャンし、脆弱性がないか調べます。

セキュリティ検出結果はマージリクエストに直接表示され、コードがマージされる前に実行可能な情報を提供します。このプロアクティブなアプローチにより、開発の後工程でイシューを修正するためのコストと労力が削減されます。

アプリケーションセキュリティテストは、いくつかのコンテキストで実行できます。

開発中: コードがコミットされたとき、またはマージリクエストが作成されたときに、CI/CDパイプラインの一部として自動スキャンが実行されます。

開発以外: セキュリティテストは、オンデマンドで手動で実行することも、定期的に実行するようにスケジュールすることもできます。

## 脆弱性管理ライフサイクル {#vulnerability-management-lifecycle}

GitLabは、次の重要なフェーズで完全な脆弱性管理ライフサイクルをサポートします。

[検出](detect/_index.md): 自動スキャンとセキュリティテストを通じて、脆弱性を特定します。

[トリアージ](triage/_index.md): 脆弱性を評価および優先順位付けして、緊急の対応が必要なものと、後で対応できるものを判別します。

[分析](analyze/_index.md): 確認済みの脆弱性を詳細に分析して、その影響を理解し、適切な修正戦略を決定します。

[修正](remediate/_index.md): 脆弱性の根本原因を修正したり、適切なリスク軽減策を実装したりします。

脆弱性は、脆弱性レポートとセキュリティダッシュボードに一元化されているため、セキュリティチームは、優先順位付けと修正の追跡をより簡単に行うことができます。

## 始める {#get-started}

開始するには、[アプリケーションの保護を開始する](get-started-security.md)を参照してください。
