/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.vcs.git.actions.GitSingleRefActions;
import com.intellij.vcs.git.ui.GitBranchPresentation;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBrancher;
import git4idea.config.GitSharedSettings;
import git4idea.i18n.GitBundle;
import git4idea.remote.hosting.GitRemoteBranchesUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionWrapper;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchPopupActions {
    private static final int MAX_BRANCH_NAME_LENGTH = 40;

    private GitBranchPopupActions() {
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchFullPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitBranchPopupActions.$$$reportNull$$$0(1);
        }
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories, false);
    }

    @NlsSafe
    @NotNull
    public static String getCurrentBranchTruncatedPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitBranchPopupActions.$$$reportNull$$$0(3);
        }
        return GitBranchPopupActions.getCurrentBranchPresentation(project, repositories, true);
    }

    @Nls
    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, boolean truncateBranchName) {
        Set currentBranches;
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitBranchPopupActions.$$$reportNull$$$0(5);
        }
        if ((currentBranches = ContainerUtil.map2SetNotNull(repositories, repo -> repo.isFresh() ? repo.getCurrentBranchName() : (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)Objects.requireNonNull(repo.getCurrentRevision()))))).size() == 1) {
            String fullBranchName = (String)currentBranches.iterator().next();
            return truncateBranchName ? GitBranchPopupActions.getCurrentBranchTruncatedName(fullBranchName, project) : GitBranchPopupActions.wrapWithQuotes(fullBranchName);
        }
        String string = GitBundle.message("branches.current.branch", new Object[0]);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchFullPresentation(@NlsSafe @NotNull String branchName) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(7);
        }
        return GitBranchPopupActions.wrapWithQuotes(branchName);
    }

    @NlsSafe
    @NotNull
    private static String getCurrentBranchTruncatedName(@NlsSafe @NotNull String branchName, @NotNull Project project) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(9);
        }
        return GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project)));
    }

    @NlsSafe
    @NotNull
    public static String getSelectedBranchTruncatedPresentation(@NotNull Project project, @NlsSafe @NotNull String branchName) {
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(10);
        }
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(11);
        }
        return GitBranchPopupActions.wrapWithQuotes(StringUtil.escapeMnemonics((String)GitBranchPopupActions.truncateBranchName(branchName, project)));
    }

    @NlsSafe
    @NotNull
    public static String truncateBranchName(@NotNull @NlsSafe String branchName, @NotNull Project project) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(12);
        }
        if (project == null) {
            GitBranchPopupActions.$$$reportNull$$$0(13);
        }
        String string = GitBranchPresentation.truncateBranchName(project, branchName, 40);
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    private static String wrapWithQuotes(@NlsSafe @NotNull String branchName) {
        if (branchName == null) {
            GitBranchPopupActions.$$$reportNull$$$0(15);
        }
        String string = "'" + branchName + "'";
        if (string == null) {
            GitBranchPopupActions.$$$reportNull$$$0(16);
        }
        return string;
    }

    public static void addTooltipText(Presentation presentation, @NlsContexts.Tooltip String tooltipText) {
        presentation.putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)tooltipText);
    }

    private static AnAction @NotNull [] getSingleBranchActions(GitBranch branch, List<? extends GitRepository> repositories, @NotNull GitRepository selectedRepository, @Nullable AnActionEvent e) {
        if (selectedRepository == null) {
            GitBranchPopupActions.$$$reportNull$$$0(17);
        }
        Object[] actions2 = GitSingleRefActions.getSingleRefActionGroup().getChildren(e);
        AnAction[] anActionArray = (AnAction[])ContainerUtil.map2Array((Object[])actions2, AnAction.class, action -> GitBranchActionWrapper.tryWrap(action, branch, selectedRepository, repositories));
        if (anActionArray == null) {
            GitBranchPopupActions.$$$reportNull$$$0(18);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 6: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateBranchName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithQuotes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleBranchActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchFullPresentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchTruncatedPresentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchPresentation";
                break;
            }
            case 6: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedBranchFullPresentation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchTruncatedName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedBranchTruncatedPresentation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "truncateBranchName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithQuotes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSingleBranchActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 16, 18 -> new IllegalStateException(string);
        };
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myTagName;

        TagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull @NlsSafe String tagName) {
            if (project == null) {
                TagActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                TagActions.$$$reportNull$$$0(1);
            }
            if (tagName == null) {
                TagActions.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new MergeAction(this.myProject, this.myRepositories, new GitTag(this.myTagName)), new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
            if (anActionArray == null) {
                TagActions.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$TagActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<? extends GitRepository> repositories, String tagName) {
                super(IdeBundle.messagePointer((String)"button.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteTagAction.$$$reportNull$$$0(0);
                }
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/ui/branch/GitBranchPopupActions$TagActions$DeleteTagAction", "actionPerformed"));
            }
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;
        @NotNull
        private final GitReference myBranch;

        MergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitReference reference) {
            GitBranch branch;
            if (project == null) {
                MergeAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                MergeAction.$$$reportNull$$$0(1);
            }
            if (reference == null) {
                MergeAction.$$$reportNull$$$0(2);
            }
            super(GitBundle.messagePointer("branches.merge.into.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranch = reference;
            this.myBranchName = reference.getName();
            this.myLocalBranch = reference instanceof GitBranch && !(branch = (GitBranch)reference).isRemote();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MergeAction.$$$reportNull$$$0(3);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(4);
            }
            Presentation presentation = e.getPresentation();
            String description = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchFullPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchFullPresentation(this.myProject, this.myRepositories));
            presentation.setDescription(description);
            GitBranchPopupActions.addTooltipText(presentation, description);
            String name = GitBundle.message("branches.merge.into", GitBranchPopupActions.getSelectedBranchTruncatedPresentation(this.myProject, this.myBranchName), GitBranchPopupActions.getCurrentBranchTruncatedPresentation(this.myProject, this.myRepositories));
            presentation.setText(name);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeAction.$$$reportNull$$$0(5);
            }
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranch, this.deleteOnMerge(this.myProject), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge(Project project) {
            if (this.myLocalBranch && !GitSharedSettings.getInstance(project).isBranchProtected(this.myBranchName)) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$MergeAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class RemoteBranchActions
    extends BranchActionGroup {
        private final List<? extends GitRepository> myRepositories;
        @NlsSafe
        private final String myBranchName;
        @NlsSafe
        private final GitRemoteBranch myBranch;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitRemoteBranch branch, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                RemoteBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                RemoteBranchActions.$$$reportNull$$$0(1);
            }
            if (branch == null) {
                RemoteBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                RemoteBranchActions.$$$reportNull$$$0(3);
            }
            this.myRepositories = repositories;
            this.myBranch = branch;
            this.myBranchName = branch.getName();
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = GitBranchPopupActions.getSingleBranchActions(this.myBranch, this.myRepositories, this.mySelectedRepository, e);
            if (anActionArray == null) {
                RemoteBranchActions.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }

        @Deprecated(forRemoval=true)
        public static final class CheckoutRemoteBranchAction {
            @Deprecated(forRemoval=true)
            @RequiresEdt
            public static void checkoutRemoteBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                if (project == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(1);
                }
                if (remoteBranchName == null) {
                    CheckoutRemoteBranchAction.$$$reportNull$$$0(2);
                }
                GitRemoteBranchesUtil.checkoutRemoteBranch(project, repositories, remoteBranchName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "remoteBranchName";
                        break;
                    }
                }
                objectArray[1] = "git4idea/ui/branch/GitBranchPopupActions$RemoteBranchActions$CheckoutRemoteBranchAction";
                objectArray[2] = "checkoutRemoteBranch";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        @NlsSafe
        protected final String myBranchName;
        protected final GitLocalBranch myBranch;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitLocalBranch branch, @NotNull GitRepository selectedRepository) {
            if (project == null) {
                LocalBranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                LocalBranchActions.$$$reportNull$$$0(1);
            }
            if (branch == null) {
                LocalBranchActions.$$$reportNull$$$0(2);
            }
            if (selectedRepository == null) {
                LocalBranchActions.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myRepositories = Collections.unmodifiableList(repositories);
            this.myBranch = branch;
            this.myBranchName = branch.getName();
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)project.getService(GitBranchManager.class));
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.myBranchName, false);
            GitBranchPopupActions.addTooltipText(this.getTemplatePresentation(), LocalBranchActions.constructIncomingOutgoingTooltip(this.hasIncomingCommits(), this.hasOutgoingCommits()));
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        public String getBranchName() {
            String string = this.myBranchName;
            if (string == null) {
                LocalBranchActions.$$$reportNull$$$0(4);
            }
            return string;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = GitBranchPopupActions.getSingleBranchActions(this.myBranch, this.myRepositories, this.mySelectedRepository, e);
            if (anActionArray == null) {
                LocalBranchActions.$$$reportNull$$$0(5);
            }
            return anActionArray;
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public static String constructIncomingOutgoingTooltip(boolean incoming, boolean outgoing) {
            if (!incoming && !outgoing) {
                return null;
            }
            if (incoming && outgoing) {
                return GitBundle.message("branches.there.are.incoming.and.outgoing.commits", new Object[0]);
            }
            if (incoming) {
                return GitBundle.message("branches.there.are.incoming.commits", new Object[0]);
            }
            return GitBundle.message("branches.there.are.outgoing.commits", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedRepository";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$LocalBranchActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBranchName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    @Deprecated(forRemoval=true)
    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            if (project == null) {
                GitNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                GitNewBranchAction.$$$reportNull$$$0(1);
            }
            super(project, repositories);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GitNewBranchAction.$$$reportNull$$$0(2);
            }
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, "HEAD", GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]), MultiRootBranches.getCommonCurrentBranch((Collection)this.myRepositories));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/ui/branch/GitBranchPopupActions$GitNewBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

