/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.FontMetrics;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.StringTokenizer;
import javajs.J2SIgnoreImport;
import jme.JME;

@J2SIgnoreImport(value={Calendar.class})
public abstract class JMEUtil {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;

    public static int[] growArray(int[] array, int newSize) {
        int[] newArray = JMEUtil.createArray(newSize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] copyArray(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static <T> T[] growArray(T[] array, int newSize) {
        assert (newSize >= array.length);
        T[] newArray = JMEUtil.copyOf(array, newSize);
        return newArray;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return JMEUtil.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static String[] growArray(String[] array, int newSize) {
        String[] newArray = JMEUtil.createSArray(newSize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] growArray(double[] array, int newSize) {
        double[] newArray = JMEUtil.createDArray(newSize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[][] growArray(int[][] array, int newSize) {
        int secondarySize = array[0].length;
        int[][] newArray = JMEUtil.createArray(newSize, secondarySize);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1.length == a2.length) {
            for (int i = 0; i < a1.length; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int[] intersection(int[] array1, int[] array2) {
        int[] common = new int[]{};
        for (int v1 : array1) {
            if (!JMEUtil.contains(array2, v1)) continue;
            common = JMEUtil.growArray(common, common.length + 1);
            common[common.length - 1] = v1;
        }
        return common;
    }

    public static boolean contains(int[] array, int v) {
        for (int each : array) {
            if (each != v) continue;
            return true;
        }
        return false;
    }

    public static <T> void swap(T[] array, int i, int j) {
        T temp = array[j];
        array[j] = array[i];
        array[i] = temp;
    }

    public static int[] copyArray(int[] array, int n) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, n);
        return copy;
    }

    public static String[] copyArray(String[] array) {
        String[] copy = new String[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static double[] copyArray(double[] array) {
        double[] copy = new double[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static int[] createArray(int size) {
        return new int[size];
    }

    public static String[] createSArray(int size) {
        return new String[size];
    }

    public static double[] createDArray(int size) {
        return new double[size];
    }

    public static long[] createLArray(int size) {
        return new long[size];
    }

    public static boolean[] createBArray(int size) {
        return new boolean[size];
    }

    public static int[][] createArray(int size1, int size2) {
        return new int[size1][size2];
    }

    public static boolean isHighDPI() {
        return false;
    }

    public static void runAsync(RunAsyncCallback runAsyncCallback) {
        runAsyncCallback.onSuccess();
    }

    public static long[] generatePrimes(int n) {
        long[] pn = JMEUtil.createLArray(n + 2);
        int[] prime = JMEUtil.createArray(100);
        int index = 0;
        int num = 0;
        boolean check = true;
        prime[0] = 3;
        pn[1] = 2L;
        pn[2] = 3L;
        int npn = 2;
        if (n < 3) {
            return pn;
        }
        for (int test = 5; test < prime[num] * prime[num]; test += 2) {
            index = 0;
            check = true;
            while (check && index <= num && test >= prime[index] * prime[index]) {
                if (test % prime[index] == 0) {
                    check = false;
                    continue;
                }
                ++index;
            }
            if (!check) continue;
            pn[++npn] = test;
            if (npn >= n) {
                return pn;
            }
            if (num >= prime.length - 1) continue;
            prime[++num] = test;
        }
        System.err.println("ERROR - Prime Number generator failed !");
        return pn;
    }

    public static String nextData(StringTokenizer st, String separator) {
        if (st.hasMoreTokens()) {
            char c;
            String s = st.nextToken();
            if (s.equals(separator)) {
                return " ";
            }
            if (!st.nextToken().equals(separator)) {
                System.err.println("mol file line separator problem!");
            }
            while ((c = s.charAt(s.length() - 1)) == '|' || c == '\n' || c == '\r') {
                if ((s = s.substring(0, s.length() - 1)).length() != 0) continue;
                return " ";
            }
            return s;
        }
        return null;
    }

    public static String findLineSeparator(String molFile) {
        StringTokenizer st = new StringTokenizer(molFile, "\n", true);
        if (st.countTokens() > 4) {
            return "\n";
        }
        st = new StringTokenizer(molFile, "|", true);
        if (st.countTokens() > 4) {
            return "|";
        }
        System.err.println("Cannot process mol file, use | as line separator !");
        return null;
    }

    public static double squareEuclideanDist(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double dotProduct(double x1, double y1, double x2, double y2) {
        return x1 * x2 + y1 * y2;
    }

    public static double triangleHeight(double a, double b, double c) {
        double s = (a + b + c) / 2.0;
        double area = Math.sqrt(s * (s - a) * (s - b) * (s - c));
        double h = 0.0;
        if (b != 0.0) {
            h = area / b * 2.0;
        }
        return h;
    }

    public static int compareAngles(double sina, double cosa, double sinb, double cosb) {
        int qa = 0;
        int qb = 0;
        if (sina >= 0.0 && cosa >= 0.0) {
            qa = 1;
        } else if (sina >= 0.0 && cosa < 0.0) {
            qa = 2;
        } else if (sina < 0.0 && cosa < 0.0) {
            qa = 3;
        } else if (sina < 0.0 && cosa >= 0.0) {
            qa = 4;
        }
        if (sinb >= 0.0 && cosb >= 0.0) {
            qb = 1;
        } else if (sinb >= 0.0 && cosb < 0.0) {
            qb = 2;
        } else if (sinb < 0.0 && cosb < 0.0) {
            qb = 3;
        } else if (sinb < 0.0 && cosb >= 0.0) {
            qb = 4;
        }
        if (qa < qb) {
            return 1;
        }
        if (qa > qb) {
            return -1;
        }
        switch (qa) {
            case 1: 
            case 4: {
                return sina < sinb ? 1 : -1;
            }
            case 2: 
            case 3: {
                return sina > sinb ? 1 : -1;
            }
        }
        System.err.println("stereowarning #31");
        return 0;
    }

    public static void stereoTransformation(int[] t, int[] ref) {
        int d = 0;
        if (ref[0] == t[1]) {
            d = t[0];
            t[0] = t[1];
            t[1] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[0] == t[2]) {
            d = t[2];
            t[2] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[3];
            t[3] = d;
        } else if (ref[0] == t[3]) {
            d = t[3];
            t[3] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[2];
            t[2] = d;
        }
        if (ref[1] == t[2]) {
            d = t[1];
            t[1] = t[2];
            t[2] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[1] == t[3]) {
            d = t[1];
            t[1] = t[3];
            t[3] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        }
    }

    public static int checkAtomicSymbol(String s) {
        for (int an = 1; an < JME.zlabel.length; ++an) {
            if (!s.equals(JME.zlabel[an])) continue;
            return an;
        }
        return 18;
    }

    public static String getSDFDateLine(String version) {
        String mol = (version + "         ").substring(0, 10);
        Calendar c = Calendar.getInstance();
        int cMM = c.get(2);
        int cDD = c.get(5);
        int cYYYY = c.get(1);
        int cHH = c.get(11);
        int cmm = c.get(12);
        mol = mol + JMEUtil.rightJustify("00", "" + (1 + cMM));
        mol = mol + JMEUtil.rightJustify("00", "" + cDD);
        mol = mol + ("" + cYYYY).substring(2, 4);
        mol = mol + JMEUtil.rightJustify("00", "" + cHH);
        mol = mol + JMEUtil.rightJustify("00", "" + cmm);
        mol = mol + "2D 1   1.00000     0.00000     0";
        return mol;
    }

    public static String iformat(int number, int len) {
        return JMEUtil.rightJustify("        ".substring(0, len), "" + number);
    }

    public static String rightJustify(String s1, String s2) {
        int n = s1.length() - s2.length();
        return n == 0 ? s2 : (n > 0 ? s1.substring(0, n) + s2 : s1.substring(0, s1.length() - 1) + "?");
    }

    public static String fformat(double number, int len, int dec) {
        double m;
        String s;
        int dotpos;
        if (dec == 0) {
            return JMEUtil.iformat((int)number, len);
        }
        if (Math.abs(number) < 9.0E-4) {
            number = 0.0;
        }
        if ((dotpos = (s = new Double(number = (double)((int)Math.round(number * (m = Math.pow(10.0, dec)))) / m).toString()).indexOf(46)) < 0) {
            s = s + ".";
            dotpos = s.indexOf(46);
        }
        int slen = s.length();
        for (int i = 1; i <= dec - slen + dotpos + 1; ++i) {
            s = s + "0";
        }
        return len == 0 ? s : JMEUtil.rightJustify("        ".substring(0, len), s);
    }

    public static double stringHeight(FontMetrics fm) {
        return fm.getAscent() - fm.getDescent();
    }

    public static interface RunWhenDataReadyCallback {
        public void onFailure(Throwable var1);

        public void onSuccess(String var1);

        public void onWarning(String var1);
    }

    public static abstract class JSME_RunAsyncCallback
    implements RunAsyncCallback {
        @Override
        public void onFailure(Throwable reason) {
        }
    }

    public static interface RunAsyncCallback {
        public void onFailure(Throwable var1);

        public void onSuccess();
    }

    public static class GWT {
        public static boolean isScript() {
            return false;
        }

        public static void log(String string) {
        }
    }
}

