/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import kafka.cluster.Partition;
import kafka.server.ReplicaManager;
import kafka.server.share.SharePartition;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.fetch.ShareFetch;
import org.apache.kafka.server.share.fetch.ShareFetchPartitionData;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

public class ShareFetchUtils {
    private static final Logger log = LoggerFactory.getLogger(ShareFetchUtils.class);

    static Map<TopicIdPartition, ShareFetchResponseData.PartitionData> processFetchResponse(ShareFetch shareFetch, List<ShareFetchPartitionData> shareFetchPartitionDataList, LinkedHashMap<TopicIdPartition, SharePartition> sharePartitions, ReplicaManager replicaManager, BiConsumer<SharePartitionKey, Throwable> exceptionHandler) {
        HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> response = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        int acquiredRecordsCount = 0;
        for (ShareFetchPartitionData shareFetchPartitionData : shareFetchPartitionDataList) {
            TopicIdPartition topicIdPartition = shareFetchPartitionData.topicIdPartition();
            FetchPartitionData fetchPartitionData = shareFetchPartitionData.fetchPartitionData();
            SharePartition sharePartition = sharePartitions.get(topicIdPartition);
            ShareFetchResponseData.PartitionData partitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition());
            if (fetchPartitionData.error.code() != Errors.NONE.code()) {
                partitionData.setRecords((BaseRecords)MemoryRecords.EMPTY).setErrorCode(fetchPartitionData.error.code()).setErrorMessage(fetchPartitionData.error.message()).setAcquiredRecords(List.of());
                if (fetchPartitionData.error.code() == Errors.OFFSET_OUT_OF_RANGE.code()) {
                    try {
                        sharePartition.updateCacheAndOffsets(ShareFetchUtils.offsetForEarliestTimestamp(topicIdPartition, replicaManager, sharePartition.leaderEpoch()));
                    }
                    catch (Exception e) {
                        log.error("Error while fetching offset for earliest timestamp for topicIdPartition: {}", (Object)topicIdPartition, (Object)e);
                        shareFetch.addErroneous(topicIdPartition, (Throwable)e);
                        exceptionHandler.accept(new SharePartitionKey(shareFetch.groupId(), topicIdPartition), e);
                        continue;
                    }
                    partitionData.setErrorCode(Errors.NONE.code());
                    partitionData.setErrorMessage(Errors.NONE.message());
                }
            } else {
                ShareAcquiredRecords shareAcquiredRecords = sharePartition.acquire(shareFetch.memberId(), shareFetch.batchSize(), shareFetch.maxFetchRecords() - acquiredRecordsCount, shareFetchPartitionData.fetchOffset(), fetchPartitionData, shareFetch.fetchParams().isolation);
                log.trace("Acquired records: {} for topicIdPartition: {}", (Object)shareAcquiredRecords, (Object)topicIdPartition);
                if (shareAcquiredRecords.acquiredRecords().isEmpty()) {
                    partitionData.setRecords((BaseRecords)MemoryRecords.EMPTY).setAcquiredRecords(List.of());
                } else {
                    partitionData.setRecords((BaseRecords)ShareFetchUtils.maybeSliceFetchRecords(fetchPartitionData.records, shareAcquiredRecords)).setAcquiredRecords(shareAcquiredRecords.acquiredRecords());
                    acquiredRecordsCount += shareAcquiredRecords.count();
                }
            }
            response.put(topicIdPartition, partitionData);
        }
        return response;
    }

    static long offsetForEarliestTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, int leaderEpoch) {
        Optional timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), -2L, (Option<IsolationLevel>)Option.empty(), Optional.of(leaderEpoch), true).timestampAndOffsetOpt();
        if (timestampAndOffset.isEmpty()) {
            throw new OffsetNotAvailableException("Offset for earliest timestamp not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FileRecords.TimestampAndOffset)timestampAndOffset.get()).offset;
    }

    static long offsetForLatestTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, int leaderEpoch) {
        Optional timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), -1L, (Option<IsolationLevel>)new Some((Object)IsolationLevel.READ_UNCOMMITTED), Optional.of(leaderEpoch), true).timestampAndOffsetOpt();
        if (timestampAndOffset.isEmpty()) {
            throw new OffsetNotAvailableException("Offset for latest timestamp not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FileRecords.TimestampAndOffset)timestampAndOffset.get()).offset;
    }

    static long offsetForTimestamp(TopicIdPartition topicIdPartition, ReplicaManager replicaManager, long timestampToSearch, int leaderEpoch) {
        Optional timestampAndOffset = replicaManager.fetchOffsetForTimestamp(topicIdPartition.topicPartition(), timestampToSearch, (Option<IsolationLevel>)new Some((Object)IsolationLevel.READ_UNCOMMITTED), Optional.of(leaderEpoch), true).timestampAndOffsetOpt();
        if (timestampAndOffset.isEmpty()) {
            throw new OffsetNotAvailableException("Offset for timestamp " + timestampToSearch + " not found for topic partition: " + String.valueOf(topicIdPartition));
        }
        return ((FileRecords.TimestampAndOffset)timestampAndOffset.get()).offset;
    }

    static int leaderEpoch(ReplicaManager replicaManager, TopicPartition tp) {
        return ShareFetchUtils.partition(replicaManager, tp).getLeaderEpoch();
    }

    static Partition partition(ReplicaManager replicaManager, TopicPartition tp) {
        Partition partition = replicaManager.getPartitionOrException(tp);
        if (!partition.isLeader()) {
            log.debug("The broker is not the leader for topic partition: {}-{}", (Object)tp.topic(), (Object)tp.partition());
            throw new NotLeaderOrFollowerException();
        }
        return partition;
    }

    static Records maybeSliceFetchRecords(Records records, ShareAcquiredRecords shareAcquiredRecords) {
        List acquiredRecords = shareAcquiredRecords.acquiredRecords();
        try {
            AbstractIterator iterator = records.batchIterator();
            RecordBatch firstOverlapBatch = (RecordBatch)iterator.next();
            if (!iterator.hasNext()) {
                return records;
            }
            long firstAcquiredOffset = ((ShareFetchResponseData.AcquiredRecords)acquiredRecords.get(0)).firstOffset();
            long lastAcquiredOffset = ((ShareFetchResponseData.AcquiredRecords)acquiredRecords.get(acquiredRecords.size() - 1)).lastOffset();
            int startPosition = 0;
            int size = 0;
            while (iterator.hasNext()) {
                RecordBatch batch = (RecordBatch)iterator.next();
                if (batch.baseOffset() <= firstAcquiredOffset) {
                    startPosition += firstOverlapBatch.sizeInBytes();
                    firstOverlapBatch = batch;
                    continue;
                }
                if (batch.baseOffset() > lastAcquiredOffset) break;
                size += batch.sizeInBytes();
            }
            if (startPosition == 0 && (size += firstOverlapBatch.sizeInBytes()) == records.sizeInBytes()) {
                return records;
            }
            return records.slice(startPosition, size);
        }
        catch (Exception e) {
            log.error("Error while checking batches for acquired records: {}, skipping slicing.", (Object)acquiredRecords, (Object)e);
            return records;
        }
    }

    public static int recordLockDurationMsOrDefault(GroupConfigManager groupConfigManager, String groupId, int defaultValue) {
        if (groupConfigManager.groupConfig(groupId).isPresent()) {
            return ((GroupConfig)groupConfigManager.groupConfig(groupId).get()).shareRecordLockDurationMs();
        }
        return defaultValue;
    }
}

