/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.LocalEventBusCodec;
import io.quarkus.vertx.deployment.LocalCodecSelectorTypesBuildItem;
import io.quarkus.vertx.deployment.MessageCodecBuildItem;
import io.quarkus.vertx.deployment.VertxConstants;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class EventBusCodecProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)EventBusCodecProcessor.class.getName());
    private static final DotName OBJECT = DotName.createSimple(Object.class);
    private static final DotName LOCAL_EVENT_BUT_CODEC = DotName.createSimple(LocalEventBusCodec.class);
    private static final List<String> BUILT_IN_CODECS = Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Integer.class.getName(), Float.class.getName(), Long.class.getName(), Short.class.getName(), String.class.getName(), Void.class.getName(), JsonObject.class.getName(), JsonArray.class.getName(), Buffer.class.getName(), io.vertx.mutiny.core.buffer.Buffer.class.getName());

    @BuildStep
    public void registerCodecs(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, CombinedIndexBuildItem combinedIndex, BuildProducer<MessageCodecBuildItem> messageCodecs, final BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<LocalCodecSelectorTypesBuildItem> localCodecSelectorTypes) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection consumeEventAnnotationInstances = index.getAnnotations(VertxConstants.CONSUME_EVENT);
        HashMap<DotName, DotName> codecByTypes = new HashMap<DotName, DotName>();
        HashSet<DotName> selectorTypes = new HashSet<DotName>();
        for (AnnotationInstance annotationInstance : consumeEventAnnotationInstances) {
            Type codecTargetFromReturnType;
            AnnotationTarget typeTarget = annotationInstance.target();
            if (typeTarget.kind() != AnnotationTarget.Kind.METHOD) {
                throw new IllegalStateException("@ConsumeEvent annotation must target a method");
            }
            AnnotationValue local = annotationInstance.value("local");
            boolean isLocal = local == null || local.asBoolean();
            MethodInfo method = typeTarget.asMethod();
            Type codecTargetFromParameter = EventBusCodecProcessor.extractPayloadTypeFromParameter(method);
            AnnotationValue codec = annotationInstance.value("codec");
            if (codec != null && codec.asClass().kind() == Type.Kind.CLASS) {
                if (codecTargetFromParameter == null) {
                    throw new IllegalStateException("Invalid `codec` argument in @ConsumeEvent - no parameter");
                }
                codecByTypes.put(codecTargetFromParameter.name(), codec.asClass().asClassType().name());
            } else if (codecTargetFromParameter != null && !EventBusCodecProcessor.hasBuiltInCodec(codecTargetFromParameter)) {
                if (!isLocal) {
                    throw new IllegalStateException("The Local Message Codec can only be used for local delivery, you will need to implement a message codec for " + codecTargetFromParameter.name().toString() + " and make use of @ConsumeEvent#codec()");
                }
                if (!codecByTypes.containsKey(codecTargetFromParameter.name())) {
                    if (EventBusCodecProcessor.isConcreteClass(codecTargetFromParameter, index)) {
                        LOGGER.debugf("Local Message Codec registered for type %s", (Object)codecTargetFromParameter);
                        codecByTypes.put(codecTargetFromParameter.name(), VertxConstants.LOCAL_EVENT_BUS_CODEC);
                    } else {
                        LOGGER.debugf("Local Message Codec will be selected for type %s", (Object)codecTargetFromParameter);
                        selectorTypes.add(codecTargetFromParameter.name());
                    }
                }
            }
            if ((codecTargetFromReturnType = EventBusCodecProcessor.extractPayloadTypeFromReturn(method)) == null || EventBusCodecProcessor.hasBuiltInCodec(codecTargetFromReturnType)) continue;
            if (!isLocal) {
                throw new IllegalStateException("The Local Message Codec can only be used for local delivery, you will need to modify the method to consume io.vertx.core.eventbus.Message, implement a message codec for " + codecTargetFromReturnType.name().toString() + " and make use of io.vertx.core.eventbus.DeliveryOptions");
            }
            if (codecByTypes.containsKey(codecTargetFromReturnType.name())) continue;
            if (EventBusCodecProcessor.isConcreteClass(codecTargetFromReturnType, index)) {
                LOGGER.debugf("Local Message Codec registered for type %s", (Object)codecTargetFromReturnType);
                codecByTypes.put(codecTargetFromReturnType.name(), VertxConstants.LOCAL_EVENT_BUS_CODEC);
                continue;
            }
            LOGGER.debugf("Local Message Codec will be selected for type %s", (Object)codecTargetFromReturnType);
            selectorTypes.add(codecTargetFromReturnType.name());
        }
        for (Map.Entry entry : codecByTypes.entrySet()) {
            messageCodecs.produce((BuildItem)new MessageCodecBuildItem(((DotName)entry.getKey()).toString(), ((DotName)entry.getValue()).toString()));
        }
        for (Map.Entry entry : codecByTypes.entrySet()) {
            DotName codecDotName;
            DotName typeDotName = (DotName)entry.getKey();
            if (OBJECT.equals((Object)typeDotName) || !LOCAL_EVENT_BUT_CODEC.equals((Object)(codecDotName = (DotName)entry.getValue()))) continue;
            Set subclasses = combinedIndex.getIndex().getAllKnownSubclasses(typeDotName).stream().map(ci -> ci.name()).filter(d -> !codecByTypes.containsKey(d)).collect(Collectors.toSet());
            for (DotName subclass : subclasses) {
                messageCodecs.produce((BuildItem)new MessageCodecBuildItem(subclass.toString(), codecDotName.toString()));
            }
        }
        codecByTypes.values().stream().map(DotName::toString).distinct().forEach(new Consumer<String>(){

            @Override
            public void accept(String name) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{name}).methods().build());
            }
        });
        localCodecSelectorTypes.produce((BuildItem)new LocalCodecSelectorTypesBuildItem(selectorTypes.stream().map(Object::toString).collect(Collectors.toSet())));
    }

    private static Type extractPayloadTypeFromReturn(MethodInfo method) {
        Type returnType = method.returnType();
        if (returnType.kind() == Type.Kind.CLASS) {
            return returnType;
        }
        if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType returnedParamType = returnType.asParameterizedType();
            if (!returnedParamType.arguments().isEmpty() && (returnedParamType.name().equals((Object)VertxConstants.COMPLETION_STAGE) || returnedParamType.name().equals((Object)VertxConstants.UNI))) {
                return (Type)returnedParamType.arguments().get(0);
            }
            return returnedParamType;
        }
        return null;
    }

    private static Type extractPayloadTypeFromParameter(MethodInfo method) {
        List parameters = method.parameterTypes();
        if (parameters.isEmpty()) {
            return null;
        }
        int messageIndex = parameters.size() == 1 ? 0 : 1;
        Type param = method.parameterType(messageIndex);
        if (param.kind() == Type.Kind.CLASS) {
            return param;
        }
        if (param.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterType = param.asParameterizedType();
            if (EventBusCodecProcessor.isMessageClass(parameterType) && !parameterType.arguments().isEmpty()) {
                return (Type)parameterType.arguments().get(0);
            }
            return parameterType;
        }
        return null;
    }

    private static boolean hasBuiltInCodec(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        String typeAsString = type.name().toString();
        return BUILT_IN_CODECS.contains(typeAsString);
    }

    private static boolean isMessageClass(ParameterizedType type) {
        return VertxConstants.isMessage(type.name());
    }

    private static boolean isConcreteClass(Type type, IndexView index) {
        ClassInfo clazz;
        if (type != null && type.kind() == Type.Kind.CLASS && (clazz = index.getClassByName(type.name())) != null) {
            return !clazz.isInterface() && !Modifier.isAbstract(clazz.flags());
        }
        return false;
    }
}

