/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.seqno;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.inject.Singleton;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.translog.Translog;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014J\b\u0010\u0007\u001a\u00020\u0005H\u0014J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterTranslogService;", "Lorg/opensearch/common/lifecycle/AbstractLifecycleComponent;", "<init>", "()V", "doStart", "", "doStop", "doClose", "getHistoryOfOperations", "", "Lorg/opensearch/index/translog/Translog$Operation;", "indexShard", "Lorg/opensearch/index/shard/IndexShard;", "startSeqNo", "", "toSeqNo", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRemoteClusterTranslogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteClusterTranslogService.kt\norg/opensearch/replication/seqno/RemoteClusterTranslogService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class RemoteClusterTranslogService
extends AbstractLifecycleComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LogManager.getLogger(RemoteClusterTranslogService.class);
    @NotNull
    private static final String SOURCE_NAME = "os_plugin_replication";

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Translog.Operation> getHistoryOfOperations(@NotNull IndexShard indexShard, long startSeqNo, long toSeqNo) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)indexShard, (String)"indexShard");
        log.trace("Fetching translog snapshot for " + indexShard + " - from " + startSeqNo + " to " + toSeqNo);
        Translog.Snapshot snapshot = indexShard.getHistoryOperationsFromTranslog(startSeqNo, toSeqNo);
        long opsSize = toSeqNo - startSeqNo + 1L;
        ArrayList<Translog.Operation> ops = new ArrayList<Translog.Operation>((int)opsSize);
        int filteredOpsFromTranslog = 0;
        Closeable closeable = (Closeable)snapshot;
        Object object = null;
        try {
            Translog.Snapshot it = (Translog.Snapshot)closeable;
            boolean bl2 = false;
            Translog.Operation op = snapshot.next();
            while (op != null) {
                long l = op.seqNo();
                boolean bl3 = startSeqNo <= l ? l <= toSeqNo : false;
                if (bl3) {
                    ops.add(op);
                    ++filteredOpsFromTranslog;
                }
                op = snapshot.next();
            }
            it = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        boolean bl4 = bl = filteredOpsFromTranslog == (int)opsSize;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Missing operations while fetching from translog";
            throw new AssertionError((Object)string);
        }
        ArrayList<Translog.Operation> sortedOps = new ArrayList<Translog.Operation>((int)opsSize);
        sortedOps.addAll((Collection)ops);
        Iterator iterator = ops.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        object = iterator;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Translog.Operation ele = (Translog.Operation)e;
            sortedOps.set((int)(ele.seqNo() - startSeqNo), ele);
        }
        log.debug("Starting seqno after sorting " + ((Translog.Operation)sortedOps.get(0)).seqNo() + " and ending seqno " + ((Translog.Operation)sortedOps.get(ops.size() - 1)).seqNo());
        List<Translog.Operation> list = sortedOps.subList(0, RangesKt.coerceAtMost((int)ops.size(), (int)((int)opsSize)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"subList(...)");
        return list;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterTranslogService$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "SOURCE_NAME", "", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

