/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeSummary;
import software.amazon.awssdk.services.ec2.model.AttributeSummaryListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeclarativePoliciesReportSummaryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetDeclarativePoliciesReportSummaryResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportId").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::reportId)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").unmarshallLocationName("reportId").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::s3Bucket)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").unmarshallLocationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::s3Prefix)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").unmarshallLocationName("s3Prefix").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::targetId)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").unmarshallLocationName("targetId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::startTime)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::endTime)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").unmarshallLocationName("endTime").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfAccounts").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::numberOfAccounts)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::numberOfAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAccounts").unmarshallLocationName("numberOfAccounts").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_FAILED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfFailedAccounts").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::numberOfFailedAccounts)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::numberOfFailedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfFailedAccounts").unmarshallLocationName("numberOfFailedAccounts").build()}).build();
    private static final SdkField<List<AttributeSummary>> ATTRIBUTE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeSummaries").getter(GetDeclarativePoliciesReportSummaryResponse.getter(GetDeclarativePoliciesReportSummaryResponse::attributeSummaries)).setter(GetDeclarativePoliciesReportSummaryResponse.setter(Builder::attributeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSummarySet").unmarshallLocationName("attributeSummarySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, S3_BUCKET_FIELD, S3_PREFIX_FIELD, TARGET_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, NUMBER_OF_ACCOUNTS_FIELD, NUMBER_OF_FAILED_ACCOUNTS_FIELD, ATTRIBUTE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeclarativePoliciesReportSummaryResponse.memberNameToFieldInitializer();
    private final String reportId;
    private final String s3Bucket;
    private final String s3Prefix;
    private final String targetId;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer numberOfAccounts;
    private final Integer numberOfFailedAccounts;
    private final List<AttributeSummary> attributeSummaries;

    private GetDeclarativePoliciesReportSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.s3Bucket = builder.s3Bucket;
        this.s3Prefix = builder.s3Prefix;
        this.targetId = builder.targetId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.numberOfAccounts = builder.numberOfAccounts;
        this.numberOfFailedAccounts = builder.numberOfFailedAccounts;
        this.attributeSummaries = builder.attributeSummaries;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer numberOfAccounts() {
        return this.numberOfAccounts;
    }

    public final Integer numberOfFailedAccounts() {
        return this.numberOfFailedAccounts;
    }

    public final boolean hasAttributeSummaries() {
        return this.attributeSummaries != null && !(this.attributeSummaries instanceof SdkAutoConstructList);
    }

    public final List<AttributeSummary> attributeSummaries() {
        return this.attributeSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfFailedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeSummaries() ? this.attributeSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeclarativePoliciesReportSummaryResponse)) {
            return false;
        }
        GetDeclarativePoliciesReportSummaryResponse other = (GetDeclarativePoliciesReportSummaryResponse)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.numberOfAccounts(), other.numberOfAccounts()) && Objects.equals(this.numberOfFailedAccounts(), other.numberOfFailedAccounts()) && this.hasAttributeSummaries() == other.hasAttributeSummaries() && Objects.equals(this.attributeSummaries(), other.attributeSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeclarativePoliciesReportSummaryResponse").add("ReportId", (Object)this.reportId()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Prefix", (Object)this.s3Prefix()).add("TargetId", (Object)this.targetId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NumberOfAccounts", (Object)this.numberOfAccounts()).add("NumberOfFailedAccounts", (Object)this.numberOfFailedAccounts()).add("AttributeSummaries", this.hasAttributeSummaries() ? this.attributeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "NumberOfAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfAccounts()));
            }
            case "NumberOfFailedAccounts": {
                return Optional.ofNullable(clazz.cast(this.numberOfFailedAccounts()));
            }
            case "AttributeSummaries": {
                return Optional.ofNullable(clazz.cast(this.attributeSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportId", REPORT_ID_FIELD);
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NumberOfAccounts", NUMBER_OF_ACCOUNTS_FIELD);
        map.put("NumberOfFailedAccounts", NUMBER_OF_FAILED_ACCOUNTS_FIELD);
        map.put("AttributeSummarySet", ATTRIBUTE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeclarativePoliciesReportSummaryResponse, T> g) {
        return obj -> g.apply((GetDeclarativePoliciesReportSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String reportId;
        private String s3Bucket;
        private String s3Prefix;
        private String targetId;
        private Instant startTime;
        private Instant endTime;
        private Integer numberOfAccounts;
        private Integer numberOfFailedAccounts;
        private List<AttributeSummary> attributeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeclarativePoliciesReportSummaryResponse model) {
            super(model);
            this.reportId(model.reportId);
            this.s3Bucket(model.s3Bucket);
            this.s3Prefix(model.s3Prefix);
            this.targetId(model.targetId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.numberOfAccounts(model.numberOfAccounts);
            this.numberOfFailedAccounts(model.numberOfFailedAccounts);
            this.attributeSummaries(model.attributeSummaries);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getNumberOfAccounts() {
            return this.numberOfAccounts;
        }

        public final void setNumberOfAccounts(Integer numberOfAccounts) {
            this.numberOfAccounts = numberOfAccounts;
        }

        @Override
        public final Builder numberOfAccounts(Integer numberOfAccounts) {
            this.numberOfAccounts = numberOfAccounts;
            return this;
        }

        public final Integer getNumberOfFailedAccounts() {
            return this.numberOfFailedAccounts;
        }

        public final void setNumberOfFailedAccounts(Integer numberOfFailedAccounts) {
            this.numberOfFailedAccounts = numberOfFailedAccounts;
        }

        @Override
        public final Builder numberOfFailedAccounts(Integer numberOfFailedAccounts) {
            this.numberOfFailedAccounts = numberOfFailedAccounts;
            return this;
        }

        public final List<AttributeSummary.Builder> getAttributeSummaries() {
            List<AttributeSummary.Builder> result = AttributeSummaryListCopier.copyToBuilder(this.attributeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeSummaries(Collection<AttributeSummary.BuilderImpl> attributeSummaries) {
            this.attributeSummaries = AttributeSummaryListCopier.copyFromBuilder(attributeSummaries);
        }

        @Override
        public final Builder attributeSummaries(Collection<AttributeSummary> attributeSummaries) {
            this.attributeSummaries = AttributeSummaryListCopier.copy(attributeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeSummaries(AttributeSummary ... attributeSummaries) {
            this.attributeSummaries(Arrays.asList(attributeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeSummaries(Consumer<AttributeSummary.Builder> ... attributeSummaries) {
            this.attributeSummaries(Stream.of(attributeSummaries).map(c -> (AttributeSummary)((AttributeSummary.Builder)AttributeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeclarativePoliciesReportSummaryResponse build() {
            return new GetDeclarativePoliciesReportSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeclarativePoliciesReportSummaryResponse> {
        public Builder reportId(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3Prefix(String var1);

        public Builder targetId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder numberOfAccounts(Integer var1);

        public Builder numberOfFailedAccounts(Integer var1);

        public Builder attributeSummaries(Collection<AttributeSummary> var1);

        public Builder attributeSummaries(AttributeSummary ... var1);

        public Builder attributeSummaries(Consumer<AttributeSummary.Builder> ... var1);
    }
}

