/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public class MLMemory
implements ToXContentObject,
Writeable {
    private String sessionId;
    private String memory;
    private MemoryType memoryType;
    private String userId;
    private String agentId;
    private String role;
    private Map<String, String> tags;
    private Instant createdTime;
    private Instant lastUpdatedTime;
    private Object memoryEmbedding;

    public MLMemory(String sessionId, String memory, MemoryType memoryType, String userId, String agentId, String role, Map<String, String> tags, Instant createdTime, Instant lastUpdatedTime, Object memoryEmbedding) {
        this.sessionId = sessionId;
        this.memory = memory;
        this.memoryType = memoryType;
        this.userId = userId;
        this.agentId = agentId;
        this.role = role;
        this.tags = tags;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.memoryEmbedding = memoryEmbedding;
    }

    public MLMemory(StreamInput in) throws IOException {
        this.sessionId = in.readString();
        this.memory = in.readString();
        this.memoryType = (MemoryType)in.readEnum(MemoryType.class);
        this.userId = in.readOptionalString();
        this.agentId = in.readOptionalString();
        this.role = in.readOptionalString();
        if (in.readBoolean()) {
            this.tags = in.readMap(StreamInput::readString, StreamInput::readString);
        }
        this.createdTime = in.readInstant();
        this.lastUpdatedTime = in.readInstant();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sessionId);
        out.writeString(this.memory);
        out.writeEnum((Enum)this.memoryType);
        out.writeOptionalString(this.userId);
        out.writeOptionalString(this.agentId);
        out.writeOptionalString(this.role);
        if (this.tags != null && !this.tags.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.tags, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeInstant(this.createdTime);
        out.writeInstant(this.lastUpdatedTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("session_id", this.sessionId);
        builder.field("memory", this.memory);
        builder.field("memory_type", this.memoryType.getValue());
        if (this.userId != null) {
            builder.field("user_id", this.userId);
        }
        if (this.agentId != null) {
            builder.field("agent_id", this.agentId);
        }
        if (this.role != null) {
            builder.field("role", this.role);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            builder.field("tags", this.tags);
        }
        builder.field("created_time", this.createdTime.toEpochMilli());
        builder.field("last_updated_time", this.lastUpdatedTime.toEpochMilli());
        if (this.memoryEmbedding != null) {
            builder.field("memory_embedding", this.memoryEmbedding);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemory parse(XContentParser parser) throws IOException {
        String sessionId = null;
        String memory = null;
        MemoryType memoryType = null;
        String userId = null;
        String agentId = null;
        String role = null;
        HashMap<String, String> tags = null;
        Instant createdTime = null;
        Instant lastUpdatedTime = null;
        Map memoryEmbedding = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block24: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "session_id": {
                    sessionId = parser.text();
                    break;
                }
                case "memory": {
                    memory = parser.text();
                    break;
                }
                case "memory_type": {
                    memoryType = MemoryType.fromString(parser.text());
                    break;
                }
                case "user_id": {
                    userId = parser.text();
                    break;
                }
                case "agent_id": {
                    agentId = parser.text();
                    break;
                }
                case "role": {
                    role = parser.text();
                    break;
                }
                case "tags": {
                    Map tagsMap = parser.map();
                    if (tagsMap == null) continue block24;
                    tags = new HashMap<String, String>();
                    for (Map.Entry entry : tagsMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        tags.put((String)entry.getKey(), entry.getValue().toString());
                    }
                    continue block24;
                }
                case "created_time": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    break;
                }
                case "last_updated_time": {
                    lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                    break;
                }
                case "memory_embedding": {
                    memoryEmbedding = parser.map();
                    break;
                }
                default: {
                    parser.skipChildren();
                }
            }
        }
        return MLMemory.builder().sessionId(sessionId).memory(memory).memoryType(memoryType).userId(userId).agentId(agentId).role(role).tags(tags).createdTime(createdTime).lastUpdatedTime(lastUpdatedTime).memoryEmbedding(memoryEmbedding).build();
    }

    public Map<String, Object> toIndexMap() {
        Map<String, Long> map = Map.of("session_id", this.sessionId, "memory", this.memory, "memory_type", this.memoryType.getValue(), "created_time", this.createdTime.toEpochMilli(), "last_updated_time", this.lastUpdatedTime.toEpochMilli());
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        if (this.userId != null) {
            result.put("user_id", (Long)((Object)this.userId));
        }
        if (this.agentId != null) {
            result.put("agent_id", (Long)((Object)this.agentId));
        }
        if (this.role != null) {
            result.put("role", (Long)((Object)this.role));
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            result.put("tags", this.tags);
        }
        if (this.memoryEmbedding != null) {
            result.put("memory_embedding", this.memoryEmbedding);
        }
        return result;
    }

    @Generated
    public static MLMemoryBuilder builder() {
        return new MLMemoryBuilder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String getMemory() {
        return this.memory;
    }

    @Generated
    public MemoryType getMemoryType() {
        return this.memoryType;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Generated
    public Instant getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Generated
    public Object getMemoryEmbedding() {
        return this.memoryEmbedding;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public void setMemory(String memory) {
        this.memory = memory;
    }

    @Generated
    public void setMemoryType(MemoryType memoryType) {
        this.memoryType = memoryType;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setRole(String role) {
        this.role = role;
    }

    @Generated
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setCreatedTime(Instant createdTime) {
        this.createdTime = createdTime;
    }

    @Generated
    public void setLastUpdatedTime(Instant lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    @Generated
    public void setMemoryEmbedding(Object memoryEmbedding) {
        this.memoryEmbedding = memoryEmbedding;
    }

    @Generated
    public static class MLMemoryBuilder {
        @Generated
        private String sessionId;
        @Generated
        private String memory;
        @Generated
        private MemoryType memoryType;
        @Generated
        private String userId;
        @Generated
        private String agentId;
        @Generated
        private String role;
        @Generated
        private Map<String, String> tags;
        @Generated
        private Instant createdTime;
        @Generated
        private Instant lastUpdatedTime;
        @Generated
        private Object memoryEmbedding;

        @Generated
        MLMemoryBuilder() {
        }

        @Generated
        public MLMemoryBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLMemoryBuilder memory(String memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MLMemoryBuilder memoryType(MemoryType memoryType) {
            this.memoryType = memoryType;
            return this;
        }

        @Generated
        public MLMemoryBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @Generated
        public MLMemoryBuilder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        @Generated
        public MLMemoryBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MLMemoryBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MLMemoryBuilder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Generated
        public MLMemoryBuilder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Generated
        public MLMemoryBuilder memoryEmbedding(Object memoryEmbedding) {
            this.memoryEmbedding = memoryEmbedding;
            return this;
        }

        @Generated
        public MLMemory build() {
            return new MLMemory(this.sessionId, this.memory, this.memoryType, this.userId, this.agentId, this.role, this.tags, this.createdTime, this.lastUpdatedTime, this.memoryEmbedding);
        }

        @Generated
        public String toString() {
            return "MLMemory.MLMemoryBuilder(sessionId=" + this.sessionId + ", memory=" + this.memory + ", memoryType=" + String.valueOf((Object)this.memoryType) + ", userId=" + this.userId + ", agentId=" + this.agentId + ", role=" + this.role + ", tags=" + String.valueOf(this.tags) + ", createdTime=" + String.valueOf(this.createdTime) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", memoryEmbedding=" + String.valueOf(this.memoryEmbedding) + ")";
        }
    }
}

