/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHPrivateKey;
import org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvXDHPublicKey;
import org.bouncycastle.util.Arrays;

class ProvXDHPrivateKey
implements Destroyable,
XDHPrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPrivateKey baseKey;

    ProvXDHPrivateKey(AsymmetricXDHPrivateKey asymmetricXDHPrivateKey) {
        this.baseKey = asymmetricXDHPrivateKey;
    }

    ProvXDHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.baseKey = new AsymmetricXDHPrivateKey(privateKeyInfo);
    }

    @Override
    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    @Override
    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    @Override
    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    @Override
    public void destroy() {
        this.baseKey.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public AsymmetricXDHPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    @Override
    public XDHPublicKey getPublicKey() {
        return new ProvXDHPublicKey(new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData()));
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("XDH");
        }
        AsymmetricXDHPublicKey asymmetricXDHPublicKey = new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), asymmetricXDHPublicKey);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProvXDHPrivateKey)) {
            return false;
        }
        ProvXDHPrivateKey provXDHPrivateKey = (ProvXDHPrivateKey)object;
        return Arrays.areEqual(provXDHPrivateKey.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricXDHPrivateKey(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

