/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.netty.implementation.DeferredCacheImmutableMap;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;
    private Map<String, String[]> abstractMultiMap;

    public NettyToAzureCoreHttpHeadersWrapper(io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    public int getSize() {
        return this.nettyHeaders.size();
    }

    @Deprecated
    public HttpHeaders add(String name, String value) {
        this.nettyHeaders.add(name, (Object)value);
        return this;
    }

    public HttpHeaders add(HttpHeaderName name, String value) {
        return this.add(name.getCaseSensitiveName(), value);
    }

    @Deprecated
    public HttpHeaders set(String name, String value) {
        this.nettyHeaders.set(name, (Object)value);
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, String value) {
        return this.set(name.getCaseSensitiveName(), value);
    }

    @Deprecated
    public HttpHeaders set(String name, List<String> values) {
        this.nettyHeaders.set(name, values);
        return this;
    }

    public HttpHeaders set(HttpHeaderName name, List<String> values) {
        return this.set(name.getCaseSensitiveName(), values);
    }

    public HttpHeaders setAll(Map<String, List<String>> headers) {
        headers.forEach(this::set);
        return this;
    }

    public HttpHeaders setAllHttpHeaders(HttpHeaders headers) {
        headers.forEach(header -> this.set(header.getName(), (List<String>)header.getValuesList()));
        return this;
    }

    @Deprecated
    public HttpHeader get(String name) {
        List values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty((Collection)values) ? null : new NettyHttpHeader(this, name, values);
    }

    public HttpHeader get(HttpHeaderName name) {
        return this.get(name.getCaseSensitiveName());
    }

    @Deprecated
    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        if (header != null) {
            this.nettyHeaders.remove(name);
        }
        return header;
    }

    public HttpHeader remove(HttpHeaderName name) {
        return this.remove(name.getCaseSensitiveName());
    }

    @Deprecated
    public String getValue(String name) {
        List values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty((Collection)values) ? null : CoreUtils.stringJoin((String)",", (List)values);
    }

    public String getValue(HttpHeaderName name) {
        return this.getValue(name.getCaseSensitiveName());
    }

    @Deprecated
    public String[] getValues(String name) {
        List values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty((Collection)values) ? null : values.toArray(new String[0]);
    }

    public String[] getValues(HttpHeaderName name) {
        return this.getValues(name.getCaseSensitiveName());
    }

    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new DeferredCacheImmutableMap<String>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> CoreUtils.stringJoin((String)",", (List)getAll));
        }
        return this.abstractMap;
    }

    Map<String, String[]> toMultiMap() {
        if (this.abstractMultiMap == null) {
            this.abstractMultiMap = new DeferredCacheImmutableMap<String[]>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> getAll.toArray(new String[0]));
        }
        return this.abstractMultiMap;
    }

    public Iterator<HttpHeader> iterator() {
        return new NettyHeadersIterator(this);
    }

    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll(name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values) {
            super(name, values);
            this.allHeaders = allHeaders;
        }

        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }

    static final class NettyHeadersIterator
    implements Iterator<HttpHeader> {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;
        private final Iterator<String> headerNames;

        NettyHeadersIterator(NettyToAzureCoreHttpHeadersWrapper allHeaders) {
            this.allHeaders = allHeaders;
            this.headerNames = allHeaders.nettyHeaders.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.headerNames.hasNext();
        }

        @Override
        public NettyHttpHeader next() {
            String headerName = this.headerNames.next();
            return new NettyHttpHeader(this.allHeaders, headerName, this.allHeaders.nettyHeaders.getAll(headerName));
        }
    }
}

