/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmi.XmlDiagramTransformer;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmiStateDiagram
implements XmlDiagramTransformer {
    private final StateDiagram diagram;
    private final Document document;
    private final Element ownedElement;

    public XmiStateDiagram(StateDiagram diagram) throws ParserConfigurationException {
        this.diagram = diagram;
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        this.document = builder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element xmi = this.document.createElement("XMI");
        xmi.setAttribute("xmi.version", "1.1");
        xmi.setAttribute("xmlns:UML", "href://org.omg/UML/1.3");
        this.document.appendChild(xmi);
        Element header = this.document.createElement("XMI.header");
        xmi.appendChild(header);
        Element metamodel = this.document.createElement("XMI.metamodel");
        metamodel.setAttribute("xmi.name", "UML");
        metamodel.setAttribute("xmi.version", "1.3");
        header.appendChild(metamodel);
        Element content = this.document.createElement("XMI.content");
        xmi.appendChild(content);
        Element model = this.document.createElement("UML:Model");
        model.setAttribute("xmi.id", CucaDiagramXmiMaker.getModel(diagram));
        model.setAttribute("name", "PlantUML");
        content.appendChild(model);
        this.ownedElement = this.document.createElement("UML:Namespace.ownedElement");
        model.appendChild(this.ownedElement);
        for (Entity gr : diagram.groups()) {
            if (!gr.getParentContainer().isRoot()) continue;
            this.addState(gr, this.ownedElement);
        }
        for (Entity ent : diagram.leafs()) {
            if (!ent.getParentContainer().isRoot()) continue;
            this.addState(ent, this.ownedElement);
        }
        for (Link link : diagram.getLinks()) {
            this.addLink(link);
        }
    }

    private void addState(Entity tobeAdded, Element container) {
        Element elementState = this.createEntityNode(tobeAdded);
        container.appendChild(elementState);
        for (Entity ent : this.diagram.groups()) {
            if (ent.getParentContainer() != tobeAdded) continue;
            this.addState(ent, elementState);
        }
        for (Entity ent : this.diagram.leafs()) {
            if (ent.getParentContainer() != tobeAdded) continue;
            this.addState(ent, elementState);
        }
    }

    public static String forXMI(String s) {
        return s.replace(':', ' ');
    }

    public static String forXMI(Display s) {
        return s.get(0).toString().replace(':', ' ');
    }

    private void addLink(Link link) {
        String assId = this.diagram.getUniqueSequence("ass");
        Element association = this.document.createElement("UML:Association");
        association.setAttribute("xmi.id", assId);
        association.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.diagram));
        if (!Display.isNull(link.getLabel())) {
            association.setAttribute("name", XmiStateDiagram.forXMI(link.getLabel()));
        }
        Element connection = this.document.createElement("UML:Association.connection");
        Element end1 = this.document.createElement("UML:AssociationEnd");
        end1.setAttribute("xmi.id", this.diagram.getUniqueSequence("end"));
        end1.setAttribute("association", assId);
        end1.setAttribute("type", link.getEntity1().getUid());
        if (link.getQuantifier1() != null) {
            end1.setAttribute("name", XmiStateDiagram.forXMI(link.getQuantifier1()));
        }
        Element endparticipant1 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor2() == LinkDecor.COMPOSITION) {
            end1.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor2() == LinkDecor.AGREGATION) {
            end1.setAttribute("aggregation", "aggregate");
        }
        end1.appendChild(endparticipant1);
        connection.appendChild(end1);
        Element end2 = this.document.createElement("UML:AssociationEnd");
        end2.setAttribute("xmi.id", this.diagram.getUniqueSequence("end"));
        end2.setAttribute("association", assId);
        end2.setAttribute("type", link.getEntity2().getUid());
        if (link.getQuantifier2() != null) {
            end2.setAttribute("name", XmiStateDiagram.forXMI(link.getQuantifier2()));
        }
        Element endparticipant2 = this.document.createElement("UML:AssociationEnd.participant");
        if (link.getType().getDecor1() == LinkDecor.COMPOSITION) {
            end2.setAttribute("aggregation", "composite");
        }
        if (link.getType().getDecor1() == LinkDecor.AGREGATION) {
            end2.setAttribute("aggregation", "aggregate");
        }
        end2.appendChild(endparticipant2);
        connection.appendChild(end2);
        association.appendChild(connection);
        this.ownedElement.appendChild(association);
    }

    private Element createEntityNode(Entity entity) {
        Element cla = this.document.createElement("UML:State");
        cla.setAttribute("xmi.id", entity.getUid());
        cla.setAttribute("name", entity.getDisplay().get(0).toString());
        cla.setAttribute("namespace", CucaDiagramXmiMaker.getModel(this.diagram));
        Element feature = this.document.createElement("UML:Classifier.feature");
        cla.appendChild(feature);
        return cla;
    }

    @Override
    public void transformerXml(OutputStream os) throws TransformerException, ParserConfigurationException {
        DOMSource source = new DOMSource(this.document);
        StreamResult resultat = new StreamResult(os);
        Transformer transformer = XmlFactories.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.transform(source, resultat);
    }
}

