/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleColorAndSizeChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleColorChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleEmoji;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleExposantChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleFontFamilyChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleImg;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleLatex;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleMath;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleMonospaced;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleOpenIcon;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleQrcode;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleSizeChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleSpace;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleSprite;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleStyle;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleSvgAttributeChange;
import net.sourceforge.plantuml.klimt.creole.command.CommandCreoleUrl;
import net.sourceforge.plantuml.klimt.font.FontPosition;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.security.SecurityUtils;

public class CommandCreoleBuilder {
    private final Map<Character, List<Command>> commands = new HashMap<Character, List<Command>>();
    public static CommandCreoleBuilder FULL = new CommandCreoleBuilder(CreoleMode.FULL);
    public static CommandCreoleBuilder OTHER = new CommandCreoleBuilder(null);

    private CommandCreoleBuilder(CreoleMode modeSimpleLine) {
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.BOLD));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.ITALIC));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.PLAIN));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.PLAIN));
        if (modeSimpleLine == CreoleMode.FULL) {
            this.addCommand(CommandCreoleStyle.createCreole(FontStyle.UNDERLINE));
        }
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.UNDERLINE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.UNDERLINE));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.STRIKE));
        this.addCommand(CommandCreoleStyle.createCreole(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.WAVE));
        this.addCommand(CommandCreoleStyle.createLegacy(FontStyle.BACKCOLOR));
        this.addCommand(CommandCreoleStyle.createLegacyEol(FontStyle.BACKCOLOR));
        this.addCommand(CommandCreoleSizeChange.create());
        this.addCommand(CommandCreoleSizeChange.createEol());
        this.addCommand(CommandCreoleColorChange.create());
        this.addCommand(CommandCreoleColorChange.createEol());
        this.addCommand(CommandCreoleColorAndSizeChange.create());
        this.addCommand(CommandCreoleColorAndSizeChange.createEol());
        this.addCommand(CommandCreoleExposantChange.create(FontPosition.EXPOSANT));
        this.addCommand(CommandCreoleExposantChange.create(FontPosition.INDICE));
        this.addCommand(CommandCreoleImg.create());
        this.addCommand(CommandCreoleQrcode.create());
        this.addCommand(CommandCreoleOpenIcon.create());
        this.addCommand(CommandCreoleEmoji.create());
        this.addCommand(CommandCreoleMath.create());
        this.addCommand(CommandCreoleLatex.create());
        this.addCommand(CommandCreoleSprite.create());
        this.addCommand(CommandCreoleSpace.create());
        this.addCommand(CommandCreoleFontFamilyChange.create());
        this.addCommand(CommandCreoleFontFamilyChange.createEol());
        this.addCommand(CommandCreoleMonospaced.create());
        this.addCommand(CommandCreoleUrl.create());
        if (SecurityUtils.allowSvgText()) {
            this.addCommand(CommandCreoleSvgAttributeChange.create());
        }
    }

    private void addCommand(Command cmd) {
        String starters = cmd.startingChars();
        for (int i = 0; i < starters.length(); ++i) {
            char ch = starters.charAt(i);
            List<Command> localList = this.commands.get(Character.valueOf(ch));
            if (localList == null) {
                localList = new ArrayList<Command>();
                this.commands.put(Character.valueOf(ch), localList);
            }
            localList.add(cmd);
        }
    }

    public Map<Character, List<Command>> getMap() {
        return this.commands;
    }
}

