/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/testFramework/AutoPopupParameterInfoTestUtil;", "", "<init>", "()V", "waitForParameterInfoUpdate", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "waitForAutoPopup", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.testFramework"})
public final class AutoPopupParameterInfoTestUtil {
    @NotNull
    public static final AutoPopupParameterInfoTestUtil INSTANCE = new AutoPopupParameterInfoTestUtil();

    private AutoPopupParameterInfoTestUtil() {
    }

    @JvmStatic
    public static final void waitForParameterInfoUpdate(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        try {
            ParameterInfoControllerBase.waitForDelayedActions((Editor)editor2, (long)1L, (TimeUnit)TimeUnit.MINUTES);
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        }
        catch (TimeoutException e) {
            TestCase.fail((String)"Timed out waiting for parameter info update");
        }
    }

    @JvmStatic
    public static final void waitForAutoPopup(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            AutoPopupController.getInstance((Project)project).waitForDelayedActions(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            TestCase.fail((String)"Timed out waiting for auto-popup");
        }
    }
}

