/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CsvReader;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.settings.CsvSettings;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatResolverCore {
    protected static final int LIMIT = 3000;

    @Nullable
    public static CsvFormat getMoreSuitableCsvFormat(@NotNull VirtualFile file, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
        if (file == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(0);
        }
        CharSequence sequence = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getContent() : (file.getFileType().isBinary() ? null : LoadTextUtil.loadText((VirtualFile)file, (int)3000));
        return sequence == null ? null : CsvFormatResolverCore.getMoreSuitableCsvFormat(sequence, tryDetectHeader, existingFormatsSupplier);
    }

    @Nullable
    public static CsvFormat getMoreSuitableCsvFormat(@NotNull CharSequence sequence) {
        if (sequence == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(1);
        }
        return CsvFormatResolverCore.getMoreSuitableCsvFormat(sequence, true, null);
    }

    @Nullable
    public static CsvFormat getMoreSuitableCsvFormat(@NotNull CharSequence sequence, boolean tryDetectHeader, @Nullable Supplier<List<CsvFormat>> existingFormatsSupplier) {
        boolean addHeader;
        if (sequence == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(2);
        }
        ArrayList<CsvFormat> formats = new ArrayList<CsvFormat>();
        List<CsvFormat> existingFormats = existingFormatsSupplier != null ? existingFormatsSupplier.get() : CsvSettings.getSettings().getCsvFormats();
        for (CsvFormat csvFormat : existingFormats) {
            if (!tryDetectHeader && !CsvFormatResolverCore.isSimple(csvFormat)) continue;
            formats.add(csvFormat);
        }
        for (CsvFormat csvFormat : existingFormats) {
            CsvFormat f;
            if (CsvFormatResolverCore.isSimple(csvFormat) || ContainerUtil.exists(formats, arg_0 -> CsvFormatResolverCore.lambda$getMoreSuitableCsvFormat$0(f = CsvFormatResolverCore.simplifyFormat(csvFormat), arg_0))) continue;
            formats.add(f);
        }
        ArrayList<MyParserResult> results = new ArrayList<MyParserResult>();
        for (CsvFormat format3 : formats) {
            StreamCsvFormatParser parser = new StreamCsvFormatParser(format3, 3000, new CsvReader(new StringReader(sequence.toString())));
            try {
                results.add(new MyParserResult(parser.parse(), format3));
            }
            catch (IOException e) {
                results.add(new MyParserResult(null, format3));
            }
        }
        results.sort(null);
        MyParserResult myParserResult = (MyParserResult)ContainerUtil.getFirstItem(results);
        if (myParserResult == null) {
            return null;
        }
        CsvFormat format = myParserResult.myFormat;
        boolean bl = addHeader = tryDetectHeader && format.headerRecord == null && !myParserResult.myHeaderAsExpected;
        if (!addHeader && existingFormats.contains(format)) {
            return format;
        }
        return CsvFormatResolverCore.withUniqueName(existingFormats, addHeader ? CsvFormatResolverCore.addHeader(format) : format);
    }

    @Nullable
    private static CsvFormat withUniqueName(List<CsvFormat> existingFormats, CsvFormat resultFormat) {
        String name;
        if (resultFormat != null && !existingFormats.contains(resultFormat) && !Objects.equals(resultFormat.name, name = CsvFormatResolverCore.getNewFormatName(resultFormat, existingFormats))) {
            resultFormat = new CsvFormat(name, resultFormat.dataRecord, resultFormat.headerRecord, resultFormat.id, resultFormat.rowNumbers);
        }
        return resultFormat;
    }

    private static boolean firstRowSeemsToBeHeader(@NotNull StreamCsvFormatParser.CsvParserResult result) {
        JBIterable records;
        StreamCsvFormatParser.Token[] first;
        if (result == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(3);
        }
        if ((first = (StreamCsvFormatParser.Token[])(records = CsvFormatResolverCore.asIterable(result.getHeader()).append(result.getRecords())).first()) == null) {
            return false;
        }
        int columnsCount = Math.min(20, first.length);
        int i = 0;
        while (i < columnsCount) {
            int idx;
            JBIterable values;
            if (!CsvFormatResolverCore.firstValueSeemsToBeHeader((JBIterable<String>)(values = records.map(arg_0 -> CsvFormatResolverCore.lambda$firstRowSeemsToBeHeader$1(idx = i++, arg_0)).take(200)))) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static boolean firstValueSeemsToBeHeader(JBIterable<@Nullable String> values) {
        TypeMerger.StringMerger stringMerger = new TypeMerger.StringMerger("");
        TypeMerger.DoubleMerger numericMerger = new TypeMerger.DoubleMerger("");
        TypeMerger merger = CsvImportUtil.getPreferredTypeMergerBasedOnContent(values, stringMerger, new TypeMerger[]{numericMerger});
        @Nullable JBIterable valuesWithoutFirstLine = values.skip(1);
        TypeMerger mergerWithoutFirstLine = CsvImportUtil.getPreferredTypeMergerBasedOnContent((Iterable<String>)valuesWithoutFirstLine, stringMerger, numericMerger);
        return merger != mergerWithoutFirstLine;
    }

    @NotNull
    private static JBIterable<StreamCsvFormatParser.Token[]> asIterable(StreamCsvFormatParser.Token[] header) {
        JBIterable jBIterable = header == null ? JBIterable.empty() : JBIterable.from(Collections.singletonList(header));
        if (jBIterable == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    private static CsvFormat addHeader(CsvFormat format) {
        return new CsvFormat(format.name, format.dataRecord, format.dataRecord, format.id, false);
    }

    public static boolean isSimple(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(5);
        }
        return !format.rowNumbers && format.headerRecord == null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static CsvFormat simplifyFormat(@Nullable CsvFormat format) {
        if (format == null || format.headerRecord == null && !format.rowNumbers) {
            return format;
        }
        return new CsvFormat(format.name + " without header", format.dataRecord, null, false);
    }

    @NotNull
    public static String getNewFormatName(@NotNull CsvFormat templateFormat, @NotNull List<CsvFormat> formats) {
        String base;
        if (templateFormat == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(6);
        }
        if (formats == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(7);
        }
        if (CsvFormatResolverCore.isUnique(base = templateFormat.name, formats)) {
            String string = base;
            if (string == null) {
                CsvFormatResolverCore.$$$reportNull$$$0(8);
            }
            return string;
        }
        int i = 1;
        while (true) {
            String name;
            if (CsvFormatResolverCore.isUnique(name = base + "_" + i, formats)) {
                String string = name;
                if (string == null) {
                    CsvFormatResolverCore.$$$reportNull$$$0(9);
                }
                return string;
            }
            ++i;
        }
    }

    private static boolean isUnique(@NotNull String name, @NotNull List<CsvFormat> formats) {
        if (name == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(10);
        }
        if (formats == null) {
            CsvFormatResolverCore.$$$reportNull$$$0(11);
        }
        return CsvFormat.indexOfFormatNamed(formats, name) == -1;
    }

    private static /* synthetic */ String lambda$firstRowSeemsToBeHeader$1(int idx, StreamCsvFormatParser.Token[] record) {
        return record[idx].getValue();
    }

    private static /* synthetic */ boolean lambda$getMoreSuitableCsvFormat$0(CsvFormat f, CsvFormat ff) {
        return CsvFormatsSettings.formatsSimilar(f, ff);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/CsvFormatResolverCore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFormat";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/CsvFormatResolverCore";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asIterable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFormatName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMoreSuitableCsvFormat";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "firstRowSeemsToBeHeader";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSimple";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNewFormatName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnique";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyParserResult
    implements Comparable<MyParserResult> {
        private final StreamCsvFormatParser.CsvParserResult myResult;
        private final CsvFormat myFormat;
        private final boolean myHeaderAsExpected;

        private MyParserResult(@Nullable StreamCsvFormatParser.CsvParserResult result, @NotNull CsvFormat format) {
            if (format == null) {
                MyParserResult.$$$reportNull$$$0(0);
            }
            this.myResult = result;
            this.myFormat = format;
            this.myHeaderAsExpected = result == null || format.headerRecord != null == CsvFormatResolverCore.firstRowSeemsToBeHeader(result);
        }

        @Override
        public int compareTo(@NotNull MyParserResult o) {
            if (o == null) {
                MyParserResult.$$$reportNull$$$0(1);
            }
            if (this.myResult == null) {
                return o.myResult == null ? 0 : 1;
            }
            if (o.myResult == null) {
                return -1;
            }
            List<StreamCsvFormatParser.Token[]> records = this.myResult.getRecords();
            List<StreamCsvFormatParser.Token[]> oRecords = o.myResult.getRecords();
            if (records.isEmpty()) {
                return oRecords.isEmpty() ? 0 : 1;
            }
            if (oRecords.isEmpty()) {
                return -1;
            }
            int compare = Integer.compare(oRecords.get(0).length, records.get(0).length);
            if (compare != 0) {
                return compare;
            }
            compare = Integer.compare(MyParserResult.errorsCount(this.myResult), MyParserResult.errorsCount(o.myResult));
            if (compare != 0) {
                return compare;
            }
            return Boolean.compare(o.myHeaderAsExpected, this.myHeaderAsExpected);
        }

        private static int errorsCount(@NotNull StreamCsvFormatParser.CsvParserResult result) {
            List<ErrorRecord> errors;
            ErrorRecord item;
            if (result == null) {
                MyParserResult.$$$reportNull$$$0(2);
            }
            if ((item = (ErrorRecord)ContainerUtil.getLastItem(errors = result.getErrors())) == null) {
                return 0;
            }
            String message = item.getMessage();
            return StringUtil.containsIgnoreCase((String)message, (String)"end of file") ? errors.size() - 1 : errors.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/csv/CsvFormatResolverCore$MyParserResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorsCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

