/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DocStringBuilder<This extends DocStringBuilder> {
    private final List<String> myLines = new ArrayList<String>();

    @NotNull
    public This addLine(@NotNull String line) {
        if (line == null) {
            DocStringBuilder.$$$reportNull$$$0(0);
        }
        This This = this.addLine(line, this.myLines.size());
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(1);
        }
        return This;
    }

    @NotNull
    public This addLine(@NotNull String line, int index) {
        if (line == null) {
            DocStringBuilder.$$$reportNull$$$0(2);
        }
        this.myLines.add(index, line);
        DocStringBuilder docStringBuilder = this;
        if (docStringBuilder == null) {
            DocStringBuilder.$$$reportNull$$$0(3);
        }
        return (This)docStringBuilder;
    }

    @NotNull
    public This addEmptyLine() {
        This This = this.addLine("", this.myLines.size());
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(4);
        }
        return This;
    }

    @NotNull
    public This addEmptyLine(int index) {
        This This = this.addLine("", index);
        if (This == null) {
            DocStringBuilder.$$$reportNull$$$0(5);
        }
        return This;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list = Collections.unmodifiableList(this.myLines);
        if (list == null) {
            DocStringBuilder.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String buildContent(int indent, boolean indentFirst) {
        String string = this.buildContent(StringUtil.repeatSymbol((char)' ', (int)indent), indentFirst);
        if (string == null) {
            DocStringBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String buildContent(@NotNull String indentation, boolean indentFirst) {
        if (indentation == null) {
            DocStringBuilder.$$$reportNull$$$0(8);
        }
        StringBuilder result2 = new StringBuilder();
        boolean first = true;
        for (String line : this.myLines) {
            if (!first) {
                result2.append('\n');
            }
            if (!StringUtil.isEmptyOrSpaces((String)line)) {
                if (!first || indentFirst) {
                    result2.append(indentation);
                }
                result2.append(line);
            }
            first = false;
        }
        String string = result2.toString();
        if (string == null) {
            DocStringBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringBuilder";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addEmptyLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLine";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }
}

