/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.crawl.DataTypeLookup;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Utility;

abstract class AbstractRetriever {
    final MutableCatalog catalog;
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;
    private final DataTypeLookup dataTypeLookup;

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        this.retrieverConnection = Objects.requireNonNull(retrieverConnection, "No retriever connection provided");
        this.catalog = catalog;
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
        this.dataTypeLookup = new DataTypeLookup(retrieverConnection, catalog);
    }

    final boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !catalogName.equals(dbObjectCatalogName)) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !schemaName.equals(dbObjectSchemaName)) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    final NamedObjectList<SchemaReference> getAllSchemas() {
        return this.catalog.getAllSchemas();
    }

    final Map<String, String> getLimitMap() {
        HashMap<String, String> limitMap = new HashMap<String, String>();
        limitMap.put("schema-inclusion-rule", MetaDataUtility.inclusionRuleString(this.options.limitOptions().get(DatabaseObjectRuleForInclusion.ruleForSchemaInclusion)));
        limitMap.put("table-inclusion-rule", MetaDataUtility.inclusionRuleString(this.options.limitOptions().get(DatabaseObjectRuleForInclusion.ruleForTableInclusion)));
        return limitMap;
    }

    final Map<String, String> getLimitMap(Schema schema) {
        Map<String, String> limitMap = this.getLimitMap();
        if (schema != null) {
            limitMap.put("catalog-name", Utility.trimToEmpty(this.catalog.getName()));
            limitMap.put("schema-name", Utility.trimToEmpty(schema.getName()));
        }
        return limitMap;
    }

    final RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    final MutableColumnDataType lookupColumnDataType(Schema schema, String databaseSpecificTypeName, int dataType) {
        return this.dataTypeLookup.lookupDataType(schema, databaseSpecificTypeName, dataType);
    }

    final MutableColumnDataType lookupOrCreateSystemColumnDataType(String databaseSpecificTypeName, int javaSqlTypeInt) {
        return this.dataTypeLookup.lookupOrCreateDataType(new SchemaReference(), databaseSpecificTypeName, DataTypeType.system, javaSqlTypeInt, null);
    }

    final MutableColumnDataType lookupOrCreateUserDefinedColumnDataType(Schema schema, String databaseSpecificTypeName, int javaSqlTypeInt, String mappedClassName) {
        return this.dataTypeLookup.lookupOrCreateDataType(schema, databaseSpecificTypeName, DataTypeType.user_defined, javaSqlTypeInt, mappedClassName);
    }

    final Optional<MutableRoutine> lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        return this.catalog.lookupRoutine(new NamedObjectKey(catalogName, schemaName, routineName, specificName));
    }

    final Optional<MutableTable> lookupTable(String catalogName, String schemaName, String tableName) {
        return this.catalog.lookupTable(new NamedObjectKey(catalogName, schemaName, tableName));
    }

    final String normalizeCatalogName(String name) {
        if (this.retrieverConnection.isSupportsCatalogs()) {
            return name;
        }
        return null;
    }

    final String normalizeSchemaName(String name) {
        if (this.retrieverConnection.isSupportsSchemas()) {
            return name;
        }
        return null;
    }
}

