/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.Locale;
import java.util.regex.Pattern;
import schemacrawler.schema.Column;

public class WeakAssociationsUtility {
    public static final Pattern ID_PATTERN = Pattern.compile("_?(id|key|keyid)$", 2);
    private static final Pattern NOT_ALPHANUMERIC_PATTERN = Pattern.compile("[^\\p{L}\\d]");

    public static String normalizeColumnName(Column column) {
        if (column == null) {
            return "";
        }
        String columnName = NOT_ALPHANUMERIC_PATTERN.matcher(column.getName()).replaceAll("").toLowerCase(Locale.ROOT);
        return columnName;
    }

    public static String removeId(Column column) {
        if (column == null) {
            return "";
        }
        String columnName = ID_PATTERN.matcher(column.getName()).replaceFirst("").toLowerCase(Locale.ROOT);
        return columnName;
    }

    private WeakAssociationsUtility() {
    }
}

