/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class MergedPropertyNames
implements TruffleObject {
    private final Object[] keys;
    private final long[] size;

    protected MergedPropertyNames(Object[] keys) throws UnsupportedMessageException {
        this.keys = keys;
        this.size = new long[keys.length];
        long s = 0L;
        InteropLibrary interop = InteropLibrary.getUncached();
        for (int i = 0; i < keys.length; ++i) {
            this.size[i] = s += interop.getArraySize(keys[i]);
        }
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.size[this.size.length - 1];
    }

    @ExportMessage
    boolean isArrayElementReadable(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop) {
        if (index >= 0L) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (index >= this.size[i]) continue;
                long start = i == 0 ? 0L : this.size[i - 1];
                return interop.isArrayElementReadable(this.keys[i], index - start);
            }
        }
        return false;
    }

    @ExportMessage
    Object readArrayElement(long index, @Cached.Shared(value="interop") @CachedLibrary(limit="5") InteropLibrary interop) throws InvalidArrayIndexException, UnsupportedMessageException {
        if (index >= 0L) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (index >= this.size[i]) continue;
                long start = i == 0 ? 0L : this.size[i - 1];
                return interop.readArrayElement(this.keys[i], index - start);
            }
        }
        throw InvalidArrayIndexException.create((long)index);
    }
}

