/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.file;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.file.FileOpenHandler;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.utils.CommonUtils;

public class FileTypeHandlerDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(FileTypeHandlerDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.fileTypeHandler";
    private final String id;
    private final AbstractDescriptor.ObjectType handlerType;
    private final int order;
    private final boolean supportsRemote;
    private final boolean isDatabaseHandler;
    private final Extension[] extensions;

    public FileTypeHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.supportsRemote = CommonUtils.toBoolean((Object)config.getAttribute("remote"), (boolean)true);
        this.isDatabaseHandler = CommonUtils.toBoolean((Object)config.getAttribute("databaseHandler"), (boolean)true);
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        ArrayList<Extension> params = new ArrayList<Extension>();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("extension");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ex = iConfigurationElementArray[n2];
            params.add(new Extension(ex, this));
            ++n2;
        }
        this.extensions = params.toArray(new Extension[0]);
    }

    public String getId() {
        return this.id;
    }

    public Extension[] getExtensions() {
        return this.extensions;
    }

    public boolean supportsRemoteFiles() {
        return this.supportsRemote;
    }

    public boolean isDatabaseHandler() {
        return this.isDatabaseHandler;
    }

    public int getOrder() {
        return this.order;
    }

    @NotNull
    public FileOpenHandler createHandler() throws DBException {
        Class<FileOpenHandler> clazz = this.handlerType.getImplClass(FileOpenHandler.class);
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DBException("Can't instantiate file handler '" + clazz.getName() + "'", e);
        }
    }

    public class Extension {
        private final FileTypeHandlerDescriptor descriptor;
        private final String id;
        private final String[] extensions;
        private final DBPImage icon;
        private final boolean supportsImport;

        Extension(@NotNull IConfigurationElement config, FileTypeHandlerDescriptor descriptor) {
            this.descriptor = descriptor;
            this.id = config.getAttribute("id");
            this.extensions = CommonUtils.notEmpty((String)config.getAttribute("extensions")).split(",");
            this.icon = FileTypeHandlerDescriptor.this.iconToImage(config.getAttribute("icon"));
            this.supportsImport = CommonUtils.toBoolean((Object)config.getAttribute("supportsImport"), (boolean)false);
        }

        @NotNull
        public FileTypeHandlerDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public DBPImage getIcon() {
            return this.icon;
        }

        @NotNull
        public String[] getExtensions() {
            return this.extensions;
        }

        public boolean isSupportsImport() {
            return this.supportsImport;
        }
    }
}

