/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.hana.model.HANATable;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class HANAPartition
extends HANATable
implements DBSTablePartition {
    private final HANATable parentTable;
    private int partId;
    private int recordCount;
    private String rangeStart;
    private String rangeEnd;
    private BigDecimal totalSize;
    private BigDecimal mainSize;
    private BigDecimal deltaSize;
    private Timestamp creationTime;
    private Timestamp lastDeltaMerge;
    private Timestamp lastLogReplay;
    private String loaded;
    private String loadUnit;

    public HANAPartition(@NotNull HANATable table, @NotNull int partId, @NotNull JDBCResultSet dbResult) {
        super((GenericStructContainer)table.getContainer(), String.valueOf(partId), table.getTableType(), dbResult);
        this.partId = partId;
        this.parentTable = table;
        this.recordCount = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"RECORD_COUNT");
        this.rangeStart = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_1_RANGE_MIN_VALUE");
        this.rangeEnd = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_1_RANGE_MAX_VALUE");
        if (CommonUtils.isEmpty((String)this.rangeStart)) {
            this.rangeStart = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_2_RANGE_MIN_VALUE");
            this.rangeEnd = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_2_RANGE_MAX_VALUE");
        }
        if (CommonUtils.isEmpty((String)this.rangeStart)) {
            this.rangeStart = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_3_RANGE_MIN_VALUE");
            this.rangeEnd = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LEVEL_3_RANGE_MAX_VALUE");
        }
        this.totalSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MEMORY_SIZE_IN_TOTAL");
        this.mainSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MEMORY_SIZE_IN_MAIN");
        this.deltaSize = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MEMORY_SIZE_IN_DELTA");
        this.creationTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.lastDeltaMerge = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_MERGE_TIME");
        this.lastLogReplay = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_REPLAY_LOG_TIME");
        this.loaded = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOADED");
        this.loadUnit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOAD_UNIT");
    }

    @Property(viewable=true, order=10)
    public int getPartId() {
        return this.partId;
    }

    @Property(viewable=true, order=30)
    public String getRangeStart() {
        return this.rangeStart;
    }

    @Property(viewable=true, order=35)
    public String getRangeEnd() {
        return this.rangeEnd;
    }

    @Property(viewable=true, order=40)
    public int getRecordCount() {
        return this.recordCount;
    }

    @Property(viewable=true, order=45, formatter=ByteNumberFormat.class)
    public BigDecimal getTotalSize() {
        return this.totalSize;
    }

    @Property(viewable=true, order=50, formatter=ByteNumberFormat.class)
    public BigDecimal getMainSize() {
        return this.mainSize;
    }

    @Property(viewable=true, order=55, formatter=ByteNumberFormat.class)
    public BigDecimal getDeltaSize() {
        return this.deltaSize;
    }

    @Property(viewable=true, order=60)
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    @Property(viewable=true, order=65)
    public Timestamp getLastDeltaMerge() {
        return this.lastDeltaMerge;
    }

    @Property(viewable=true, order=70)
    public Timestamp getLastLogReplay() {
        return this.lastLogReplay;
    }

    @Property(viewable=true, order=75)
    public String getLoaded() {
        return this.loaded;
    }

    @Property(viewable=true, order=80)
    public String getLoadUnit() {
        return this.loadUnit;
    }

    @Override
    public boolean hasStatistics() {
        return false;
    }

    @Override
    public long getStatObjectSize() {
        return 0L;
    }

    public DBSTable getParentTable() {
        return this.parentTable;
    }

    public boolean isSubPartition() {
        return false;
    }

    public DBSTablePartition getPartitionParent() {
        return null;
    }
}

