/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsPotentialTestContainer;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.1")
public class IsTestClassWithTests
implements Predicate<Class<?>> {
    private static final IsTestMethod isTestMethod = new IsTestMethod();
    private static final IsTestFactoryMethod isTestFactoryMethod = new IsTestFactoryMethod();
    private static final IsTestTemplateMethod isTestTemplateMethod = new IsTestTemplateMethod();
    public static final Predicate<Method> isTestOrTestFactoryOrTestTemplateMethod = isTestMethod.or(isTestFactoryMethod).or(isTestTemplateMethod);
    private static final IsPotentialTestContainer isPotentialTestContainer = new IsPotentialTestContainer();
    private static final IsNestedTestClass isNestedTestClass = new IsNestedTestClass();

    @Override
    public boolean test(Class<?> candidate) {
        return isPotentialTestContainer.test(candidate) && (this.hasTestOrTestFactoryOrTestTemplateMethods(candidate) || this.hasNestedTests(candidate));
    }

    private boolean hasTestOrTestFactoryOrTestTemplateMethods(Class<?> candidate) {
        return ReflectionUtils.isMethodPresent(candidate, isTestOrTestFactoryOrTestTemplateMethod);
    }

    private boolean hasNestedTests(Class<?> candidate) {
        return !ReflectionSupport.findNestedClasses(candidate, (Predicate)isNestedTestClass).isEmpty();
    }
}

