/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.scilab.forge.jlatexmath.Box;

public class GraphicsBox
extends Box {
    public static final int BILINEAR = 0;
    public static final int NEAREST_NEIGHBOR = 1;
    public static final int BICUBIC = 2;
    private BufferedImage image;
    private float scl;
    private Object interp;

    public GraphicsBox(BufferedImage image, float width, float height, float size, int interpolation) {
        this.image = image;
        this.width = width;
        this.height = height;
        this.scl = 1.0f / size;
        this.depth = 0.0f;
        this.shift = 0.0f;
        switch (interpolation) {
            case 0: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            case 1: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 2: {
                this.interp = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                break;
            }
            default: {
                this.interp = null;
            }
        }
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform oldAt = g2.getTransform();
        Object oldKey = null;
        if (this.interp != null) {
            oldKey = g2.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interp);
        }
        g2.translate(x, y - this.height);
        g2.scale(this.scl, this.scl);
        g2.drawImage((Image)this.image, 0, 0, null);
        g2.setTransform(oldAt);
        if (oldKey != null) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldKey);
        }
    }

    @Override
    public int getLastFontId() {
        return 0;
    }
}

