/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.OverlayHelpTree;
import help.TOCItemProvider;
import help.validator.DuplicateAnchorCollection;
import help.validator.DuplicateAnchorCollectionByHelpFile;
import help.validator.DuplicateAnchorCollectionByHelpTopic;
import help.validator.links.InvalidHREFLink;
import help.validator.links.InvalidLink;
import help.validator.location.HelpModuleCollection;
import help.validator.model.AnchorDefinition;
import help.validator.model.GhidraTOCFile;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.TOCItemDefinition;
import help.validator.model.TOCItemExternal;
import help.validator.model.TOCItemReference;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class LinkDatabase {
    private Set<InvalidLink> allUnresolvedLinks = new TreeSet<InvalidLink>(new Comparator<InvalidLink>(this){

        @Override
        public int compare(InvalidLink o1, InvalidLink o2) {
            int lineNumber2;
            Path file2;
            String name2;
            String name1 = o1.getClass().getSimpleName();
            if (!name1.equals(name2 = o2.getClass().getSimpleName())) {
                return name1.compareTo(name2);
            }
            Path file1 = o1.getSourceFile();
            if (!file1.equals(file2 = o2.getSourceFile())) {
                return file1.toUri().compareTo(file2.toUri());
            }
            int lineNumber1 = o1.getLineNumber();
            if (lineNumber1 != (lineNumber2 = o2.getLineNumber())) {
                return lineNumber1 - lineNumber2;
            }
            return o1.identityHashCode() - o2.identityHashCode();
        }
    });
    private final Set<DuplicateAnchorCollection> duplicateAnchors = new TreeSet<DuplicateAnchorCollection>(new Comparator<DuplicateAnchorCollection>(this){

        @Override
        public int compare(DuplicateAnchorCollection o1, DuplicateAnchorCollection o2) {
            if (o1.getClass().equals(o2.getClass())) {
                if (o1 instanceof DuplicateAnchorCollectionByHelpTopic) {
                    DuplicateAnchorCollectionByHelpTopic d1 = (DuplicateAnchorCollectionByHelpTopic)o1;
                    DuplicateAnchorCollectionByHelpTopic d2 = (DuplicateAnchorCollectionByHelpTopic)o2;
                    return d1.compareTo(d2);
                }
                if (o1 instanceof DuplicateAnchorCollectionByHelpFile) {
                    DuplicateAnchorCollectionByHelpFile d1 = (DuplicateAnchorCollectionByHelpFile)o1;
                    DuplicateAnchorCollectionByHelpFile d2 = (DuplicateAnchorCollectionByHelpFile)o2;
                    return d1.compareTo(d2);
                }
                throw new RuntimeException("New type of DuplicateAnchorCollection not handled by this comparator");
            }
            return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
        }
    });
    private final HelpModuleCollection helpCollection;
    private final Map<String, TOCItemDefinition> mapOfIDsToTOCDefinitions = new HashMap<String, TOCItemDefinition>();
    private final Map<String, TOCItemExternal> mapOfIDsToTOCExternals = new HashMap<String, TOCItemExternal>();
    private OverlayHelpTree printableTree;

    public LinkDatabase(HelpModuleCollection helpCollection) {
        this.helpCollection = helpCollection;
        this.collectTOCItemDefinitions(helpCollection);
        this.collectTOCItemExternals(helpCollection);
        this.printableTree = new OverlayHelpTree(helpCollection, this);
    }

    private void collectTOCItemDefinitions(TOCItemProvider tocProvider) {
        Map<String, TOCItemDefinition> map = tocProvider.getTocDefinitionsByID();
        Set<Map.Entry<String, TOCItemDefinition>> entrySet = map.entrySet();
        for (Map.Entry<String, TOCItemDefinition> entry : entrySet) {
            String key = entry.getKey();
            TOCItemDefinition value = entry.getValue();
            if (this.mapOfIDsToTOCDefinitions.containsKey(key)) {
                throw new IllegalArgumentException("Cannot define the same TOC definition more than once!  Original definition: " + String.valueOf(this.mapOfIDsToTOCDefinitions.get(key)) + "\nSecond definition: " + String.valueOf(value));
            }
            this.mapOfIDsToTOCDefinitions.put(key, value);
        }
    }

    private void collectTOCItemExternals(TOCItemProvider tocProvider) {
        Map<String, TOCItemExternal> map = tocProvider.getExternalTocItemsById();
        for (TOCItemExternal tocItem : map.values()) {
            this.mapOfIDsToTOCExternals.put(tocItem.getIDAttribute(), tocItem);
        }
    }

    public TOCItemDefinition getTOCDefinition(TOCItemReference referenceTOC) {
        return this.mapOfIDsToTOCDefinitions.get(referenceTOC.getIDAttribute());
    }

    public TOCItemExternal getTOCExternal(TOCItemReference referenceTOC) {
        return this.mapOfIDsToTOCExternals.get(referenceTOC.getIDAttribute());
    }

    HelpFile resolveLink(InvalidLink link) {
        if (!(link instanceof InvalidHREFLink)) {
            return null;
        }
        InvalidHREFLink hrefLink = (InvalidHREFLink)link;
        HREF href = hrefLink.getHREF();
        Path helpPath = href.getReferenceFileHelpPath();
        return this.findHelpFileForPath(helpPath);
    }

    HelpFile resolveFile(Path referenceFileHelpPath) {
        return this.findHelpFileForPath(referenceFileHelpPath);
    }

    private HelpFile findHelpFileForPath(Path helpPath) {
        HelpFile helpFile = this.helpCollection.getHelpFile(helpPath);
        if (helpFile != null) {
            return helpFile;
        }
        return null;
    }

    Collection<InvalidLink> getUnresolvedLinks() {
        return this.allUnresolvedLinks;
    }

    public Collection<DuplicateAnchorCollection> getDuplicateAnchors() {
        return this.duplicateAnchors;
    }

    void addUnresolvedLinks(Collection<InvalidLink> unresolvedLinks) {
        this.allUnresolvedLinks.addAll(unresolvedLinks);
    }

    void addDuplicateAnchors(DuplicateAnchorCollection collection) {
        this.duplicateAnchors.add(collection);
    }

    public String getIDForLink(String target) {
        if (target.startsWith("external:")) {
            return null;
        }
        Path path = Paths.get(target, new String[0]);
        Path file = Paths.get(target.split("#")[0], new String[0]);
        HelpFile helpFile = this.findHelpFileForPath(file);
        if (helpFile == null) {
            return null;
        }
        AnchorDefinition definition = helpFile.getAnchorDefinition(path);
        if (definition == null) {
            return null;
        }
        return definition.getId();
    }

    public void generateTOCOutputFile(Path outputFile, GhidraTOCFile file) throws IOException {
        this.printableTree.printTreeForID(outputFile, file.getFile().toUri().toString());
    }
}

