/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import org.jungrapht.visualization.control.AbstractGraphMouse;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.RegionSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.SelectingGraphMousePlugin;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.VertexSelectingGraphMousePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGraphMouse<V, E>
extends AbstractGraphMouse {
    private static Logger log = LoggerFactory.getLogger(DefaultGraphMouse.class);
    protected int singleSelectionMask;
    protected int toggleSingleSelectionMask;
    protected int regionSelectionMask;
    protected int toggleRegionSelectionMask;
    protected int regionSelectionCompleteMask;
    protected int toggleRegionSelectionCompleteMask;
    protected int translatingMask;
    protected int scalingMask;
    protected int xAxisScalingMask;
    protected int yAxisScalingMask;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected DefaultGraphMouse(Builder<V, E, ?, ?> builder) {
        this(builder.in, builder.out, builder.vertexSelectionOnly, builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask, builder.translatingMask, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
    }

    public DefaultGraphMouse() {
        this(new Builder());
    }

    DefaultGraphMouse(float in, float out, boolean vertexSelectionOnly, int singleSelectionMask, int toggleSingleSelectionMask, int regionSelectionMask, int toggleRegionSelectionMask, int regionSelectionCompleteMask, int toggleRegionSelectionCompleteMask, int translatingMask, int scalingMask, int xAxisScalingMask, int yAxisScalingMask) {
        super(in, out, vertexSelectionOnly);
        this.singleSelectionMask = singleSelectionMask;
        this.toggleSingleSelectionMask = toggleSingleSelectionMask;
        this.regionSelectionMask = regionSelectionMask;
        this.toggleRegionSelectionMask = toggleRegionSelectionMask;
        this.regionSelectionCompleteMask = regionSelectionCompleteMask;
        this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
        this.translatingMask = translatingMask;
        this.scalingMask = scalingMask;
        this.xAxisScalingMask = xAxisScalingMask;
        this.yAxisScalingMask = yAxisScalingMask;
    }

    @Override
    public void loadPlugins() {
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), this.scalingMask, this.xAxisScalingMask, this.yAxisScalingMask, this.in, this.out);
        this.selectingPlugin = this.vertexSelectionOnly ? new VertexSelectingGraphMousePlugin(this.singleSelectionMask, this.toggleSingleSelectionMask, false) : ((SelectingGraphMousePlugin.Builder)((SelectingGraphMousePlugin.Builder)SelectingGraphMousePlugin.builder().singleSelectionMask(this.singleSelectionMask)).toggleSingleSelectionMask(this.toggleSingleSelectionMask)).build();
        this.regionSelectingPlugin = ((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)((RegionSelectingGraphMousePlugin.Builder)RegionSelectingGraphMousePlugin.builder().regionSelectionMask(this.regionSelectionMask)).toggleRegionSelectionMask(this.toggleRegionSelectionMask)).regionSelectionCompleteMask(this.regionSelectionCompleteMask)).toggleRegionSelectionCompleteMask(this.toggleRegionSelectionCompleteMask)).build();
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.scalingPlugin);
    }

    @Override
    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    public static class Builder<V, E, T extends DefaultGraphMouse, B extends Builder<V, E, T, B>>
    extends AbstractGraphMouse.Builder<T, B> {
        protected int singleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.singleSelectionMask", "MB1_MENU"));
        protected int toggleSingleSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleSingleSelectionMask", "MB1_SHIFT_MENU"));
        protected int regionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionMask", "MB1_MENU"));
        protected int toggleRegionSelectionMask = Modifiers.masks.get(System.getProperty("jungrapht.addregionSelectionMask", "MB1_SHIFT_MENU"));
        protected int regionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.regionSelectionCompleteMask", "MENU"));
        protected int toggleRegionSelectionCompleteMask = Modifiers.masks.get(System.getProperty("jungrapht.toggleRegionSelectionCompleteMask", "SHIFT_MENU"));
        protected int translatingMask = Modifiers.masks.get(System.getProperty("jungrapht.translatingMask", "MB1"));
        protected int xAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.xAxisScalingMask", "MENU"));
        protected int yAxisScalingMask = Modifiers.masks.get(System.getProperty("jungrapht.yAxisScalingMask", "ALT"));
        protected int scalingMask = Modifiers.masks.get(System.getProperty("jungrapht.scalingMask", "NONE"));

        public B singleSelectionMask(int singleSelectionMask) {
            this.singleSelectionMask = singleSelectionMask;
            return (B)((Builder)this.self());
        }

        public B toggleSingleSelectionMask(int toggleSingleSelectionMask) {
            this.toggleSingleSelectionMask = toggleSingleSelectionMask;
            return (B)((Builder)this.self());
        }

        public B regionSelectionMask(int regionSelectionMask) {
            this.regionSelectionMask = regionSelectionMask;
            return (B)((Builder)this.self());
        }

        public B toggleRegionSelectionMask(int toggleRegionSelectionMask) {
            this.toggleRegionSelectionMask = toggleRegionSelectionMask;
            return (B)((Builder)this.self());
        }

        public B regionSelectionCompleteMask(int regionSelectionCompleteMask) {
            this.regionSelectionCompleteMask = regionSelectionCompleteMask;
            return (B)((Builder)this.self());
        }

        public B toggleRegionSelectionCompleteMask(int toggleRegionSelectionCompleteMask) {
            this.toggleRegionSelectionCompleteMask = toggleRegionSelectionCompleteMask;
            return (B)((Builder)this.self());
        }

        public B translatingMask(int translatingMask) {
            this.translatingMask = translatingMask;
            return (B)((Builder)this.self());
        }

        public B scalingMask(int scalingMask) {
            this.scalingMask = scalingMask;
            return (B)((Builder)this.self());
        }

        public B xAxisScalingMask(int xAxisScalingMask) {
            this.xAxisScalingMask = xAxisScalingMask;
            return (B)((Builder)this.self());
        }

        public B yAxisScalingMask(int yAxisScalingMask) {
            this.yAxisScalingMask = yAxisScalingMask;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new DefaultGraphMouse(this);
        }
    }
}

