/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ComputeChecksumsProvider;
import ghidra.app.plugin.core.checksums.MemoryInputStream;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class CRC32ChecksumAlgorithm
extends ChecksumAlgorithm {
    public CRC32ChecksumAlgorithm() {
        super("CRC-32");
    }

    @Override
    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, ComputeChecksumsProvider provider) throws MemoryAccessException, CancelledException {
        if (provider == null) {
            this.updateChecksum(memory, addrSet, monitor, false, false);
        } else {
            this.updateChecksum(memory, addrSet, monitor, provider.isOnes(), provider.isTwos());
        }
    }

    public void updateChecksum(Memory memory, AddressSetView addrSet, TaskMonitor monitor, boolean onesComp, boolean twosComp) throws MemoryAccessException, CancelledException {
        long crc;
        byte[] bytes = new byte[1024];
        try (CheckedInputStream cis = new CheckedInputStream(new MemoryInputStream(memory, addrSet), new CRC32());){
            while (cis.read(bytes) > 0) {
                if (!monitor.isCancelled()) continue;
                throw new CancelledException();
            }
            crc = cis.getChecksum().getValue();
        }
        catch (IOException e) {
            throw new MemoryAccessException(e.getMessage());
        }
        if (onesComp) {
            crc ^= 0xFFFFFFFFFFFFFFFFL;
        } else if (twosComp) {
            crc = -crc;
        }
        this.checksum = CRC32ChecksumAlgorithm.toArray(crc, 4);
    }

    @Override
    public boolean supportsDecimal() {
        return true;
    }
}

