/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.util.List;

class DerivativeDataTypeInfo {
    private final DataTypeManagerPlugin plugin;
    private DataTypeManager dataTypeManager;
    private CategoryPath categoryPath;
    private GTreeNode parentNode;

    DerivativeDataTypeInfo(DataTypeManagerPlugin plugin, DataTypeArchiveGTree gTree, GTreeNode selectedNode, DataType baseDataType) {
        this.plugin = plugin;
        this.parentNode = selectedNode.getParent();
        this.categoryPath = baseDataType.getCategoryPath();
        this.dataTypeManager = baseDataType.getDataTypeManager();
        if (this.dataTypeManager instanceof BuiltInDataTypeManager) {
            this.dataTypeManager = plugin.getProgramDataTypeManager();
            SystemUtilities.assertTrue((this.dataTypeManager != null ? 1 : 0) != 0, (String)("Cannot create a " + this.getClass().getSimpleName() + " instance from the built-in data type manager when no program is open"));
            this.categoryPath = new CategoryPath("/");
            this.parentNode = this.getProgramArchiveNode(gTree);
        }
    }

    DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    GTreeNode getParentNode() {
        return this.parentNode;
    }

    private ArchiveNode getProgramArchiveNode(DataTypeArchiveGTree tree) {
        DataTypeManager manager = this.plugin.getProgramDataTypeManager();
        GTreeNode rootNode = tree.getModelRoot();
        List children = rootNode.getChildren();
        for (GTreeNode node : children) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            if (archive.getDataTypeManager() != manager) continue;
            return archiveNode;
        }
        throw new AssertException("Somehow program node is opened in the tool");
    }
}

