/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.model.InstructionSearchData;
import ghidra.app.plugin.core.instructionsearch.model.MaskSettings;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class InstructionSearchApi {
    public final List<Address> search(Program program, AddressRange addressRange) throws InvalidInputException {
        InstructionSearchData searchData = new InstructionSearchData();
        searchData.load(program, addressRange);
        ArrayList<InstructionMetadata> searchResults = new ArrayList<InstructionMetadata>();
        AddressRangeIterator rangeIter = program.getMemory().getLoadedAndInitializedAddressSet().getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            searchResults.addAll(searchData.search(program, range, TaskMonitor.DUMMY));
        }
        return InstructionSearchUtils.toAddressList(searchResults);
    }

    public final List<Address> search(Program program, AddressRange addressRange, MaskSettings maskSettings) throws InvalidInputException {
        InstructionSearchData searchData = new InstructionSearchData();
        searchData.load(program, addressRange);
        if (maskSettings.isMaskOperands()) {
            searchData.maskAllOperands();
        } else {
            if (maskSettings.isMaskScalars()) {
                searchData.maskOperandsByType(16384);
            }
            if (maskSettings.isMaskAddresses()) {
                searchData.maskOperandsByType(8192);
            }
        }
        ArrayList<InstructionMetadata> searchResults = new ArrayList<InstructionMetadata>();
        AddressRangeIterator rangeIter = program.getMemory().getLoadedAndInitializedAddressSet().getAddressRanges();
        while (rangeIter.hasNext()) {
            AddressRange range = (AddressRange)rangeIter.next();
            searchResults.addAll(searchData.search(program, range, TaskMonitor.DUMMY));
        }
        return InstructionSearchUtils.toAddressList(searchResults);
    }

    public final String getBinarySearchString(Program program, AddressRange addressRange) throws InvalidInputException {
        MaskSettings maskSettings = new MaskSettings(false, false, false);
        String searchString = this.getBinarySearchString(program, addressRange, maskSettings);
        return searchString;
    }

    public final String getHexSearchString(Program program, AddressRange addressRange) throws InvalidInputException {
        return InstructionSearchUtils.toHexNibblesOnly(this.getBinarySearchString(program, addressRange)).toString();
    }

    public final String getBinarySearchString(Program program, AddressRange addressRange, MaskSettings maskSettings) throws InvalidInputException {
        InstructionSearchData searchData = new InstructionSearchData();
        searchData.load(program, addressRange);
        if (maskSettings.isMaskOperands()) {
            searchData.maskAllOperands();
        } else {
            if (maskSettings.isMaskScalars()) {
                searchData.maskOperandsByType(16384);
            }
            if (maskSettings.isMaskAddresses()) {
                searchData.maskOperandsByType(8192);
            }
        }
        return searchData.getCombinedString();
    }

    public final String getHexSearchString(Program program, AddressRange addressRange, MaskSettings maskSettings) throws InvalidInputException {
        return InstructionSearchUtils.toHexNibblesOnly(this.getBinarySearchString(program, addressRange, maskSettings)).toString();
    }

    public void loadInstructions(AddressSet addresses, PluginTool tool) {
        InstructionSearchDialog searchDialog = new InstructionSearchDialog(InstructionSearchUtils.getInstructionSearchPlugin(tool), "Search Dialog", null);
        tool.showDialog((DialogComponentProvider)searchDialog);
        searchDialog.loadBytes(addresses);
    }

    public void loadInstructions(String bytes, PluginTool tool) {
        InstructionSearchDialog searchDialog = new InstructionSearchDialog(InstructionSearchUtils.getInstructionSearchPlugin(tool), "Search Dialog", null);
        tool.showDialog((DialogComponentProvider)searchDialog);
        searchDialog.loadBytes(bytes);
    }
}

