/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.stackeditor;

import docking.action.DockingActionIf;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.core.stackeditor.EditStackAction;
import ghidra.app.plugin.core.stackeditor.StackEditorManager;
import ghidra.app.plugin.core.stackeditor.StackEditorOptionManager;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Stack editor", description="This plugin provides an action and dialog for editing a function's stack frame.", servicesRequired={DataTypeManagerService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class StackEditorManagerPlugin
extends Plugin
implements OptionsChangeListener,
StackEditorOptionManager {
    private static final String EDITOR_NAME = "Stack Editor";
    private static final String HEX_NUMBERS_OPTION_NAME = "Stack Editor.Show Numbers In Hex";
    private EditStackAction editStackAction;
    private StackEditorManager editorMgr = new StackEditorManager(this);
    private DataTypeManagerService dtmService;
    private boolean showNumbersInHex = true;
    private String HELP_TOPIC = "StackEditor";

    public StackEditorManagerPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        ToolOptions options = tool.getOptions("Editors");
        this.initializeOptions((Options)options);
        options.addOptionsChangeListener((OptionsChangeListener)this);
    }

    protected void init() {
        this.initializeServices();
    }

    private void initializeServices() {
        this.dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (this.dtmService == null) {
            throw new AssertException("DataTypeManagerService was not found!");
        }
    }

    public void dispose() {
        this.editorMgr.dispose();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program p = ((ProgramClosedPluginEvent)event).getProgram();
            this.editorMgr.programClosed(p);
        }
        super.processEvent(event);
    }

    private void createActions() {
        this.editStackAction = new EditStackAction(this, this.dtmService);
        this.tool.addAction((DockingActionIf)this.editStackAction);
    }

    protected boolean canClose() {
        return this.editorMgr.canClose();
    }

    protected void close() {
        this.editorMgr.close();
    }

    public void edit(Function function) {
        this.editorMgr.edit(function);
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        return this.editorMgr.canCloseDomainObject(dObj);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.setOptions((Options)options);
    }

    private void initializeOptions(Options options) {
        HelpLocation helpLocation = new HelpLocation(this.HELP_TOPIC, "StackEditorToolOptions");
        options.setOptionsHelpLocation(helpLocation);
        options.getOptions(EDITOR_NAME).setOptionsHelpLocation(helpLocation);
        String description = "Toggle for whether numeric values in the Stack Frame Editor should be displayed in hexadecimal or decimal when you initially begin editing a stack frame.";
        options.registerOption(HEX_NUMBERS_OPTION_NAME, (Object)this.showNumbersInHex, helpLocation, description);
    }

    private void setOptions(Options options) {
        this.showNumbersInHex = options.getBoolean(HEX_NUMBERS_OPTION_NAME, this.showNumbersInHex);
    }

    public void updateOptions() {
        ToolOptions options = this.tool.getOptions("Editors");
        options.setBoolean(HEX_NUMBERS_OPTION_NAME, this.showNumbersInHex);
    }

    @Override
    public boolean showStackNumbersInHex() {
        return this.showNumbersInHex;
    }
}

