/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.ObsoleteException;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public abstract class ObsoleteCommand
extends LoadCommand {
    public ObsoleteCommand(BinaryReader reader) throws IOException, MachException {
        super(reader);
        throw new ObsoleteException();
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.getByteArray(), "obsolete", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    private DataType getByteArray() {
        return new ArrayDataType(BYTE, this.getCommandSize() - 8, BYTE.getLength());
    }
}

