/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolAux;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolTable;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Conv;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DebugCOFFSymbol
implements StructConverter {
    private static final int NAME_LENGTH = 8;
    public static final int IMAGE_SIZEOF_SYMBOL = 18;
    public static final short IMAGE_SYM_UNDEFINED = 0;
    public static final short IMAGE_SYM_ABSOLUTE = -1;
    public static final short IMAGE_SYM_DEBUG = -2;
    public static final short IMAGE_SYM_TYPE_NULL = 0;
    public static final short IMAGE_SYM_TYPE_VOID = 1;
    public static final short IMAGE_SYM_TYPE_CHAR = 2;
    public static final short IMAGE_SYM_TYPE_SHORT = 3;
    public static final short IMAGE_SYM_TYPE_INT = 4;
    public static final short IMAGE_SYM_TYPE_LONG = 5;
    public static final short IMAGE_SYM_TYPE_FLOAT = 6;
    public static final short IMAGE_SYM_TYPE_DOUBLE = 7;
    public static final short IMAGE_SYM_TYPE_STRUCT = 8;
    public static final short IMAGE_SYM_TYPE_UNION = 9;
    public static final short IMAGE_SYM_TYPE_ENUM = 10;
    public static final short IMAGE_SYM_TYPE_MOE = 11;
    public static final short IMAGE_SYM_TYPE_BYTE = 12;
    public static final short IMAGE_SYM_TYPE_WORD = 13;
    public static final short IMAGE_SYM_TYPE_UINT = 14;
    public static final short IMAGE_SYM_TYPE_DWORD = 15;
    public static final short IMAGE_SYM_TYPE_PCODE = Short.MIN_VALUE;
    public static final short IMAGE_SYM_DTYPE_NULL = 0;
    public static final short IMAGE_SYM_DTYPE_POINTER = 1;
    public static final short IMAGE_SYM_DTYPE_FUNCTION = 2;
    public static final short IMAGE_SYM_DTYPE_ARRAY = 3;
    public static final byte IMAGE_SYM_CLASS_END_OF_FUNCTION = -1;
    public static final byte IMAGE_SYM_CLASS_NULL = 0;
    public static final byte IMAGE_SYM_CLASS_AUTOMATIC = 1;
    public static final byte IMAGE_SYM_CLASS_EXTERNAL = 2;
    public static final byte IMAGE_SYM_CLASS_STATIC = 3;
    public static final byte IMAGE_SYM_CLASS_REGISTER = 4;
    public static final byte IMAGE_SYM_CLASS_EXTERNAL_DEF = 5;
    public static final byte IMAGE_SYM_CLASS_LABEL = 6;
    public static final byte IMAGE_SYM_CLASS_UNDEFINED_LABEL = 7;
    public static final byte IMAGE_SYM_CLASS_MEMBER_OF_STRUCT = 8;
    public static final byte IMAGE_SYM_CLASS_ARGUMENT = 9;
    public static final byte IMAGE_SYM_CLASS_STRUCT_TAG = 10;
    public static final byte IMAGE_SYM_CLASS_MEMBER_OF_UNION = 11;
    public static final byte IMAGE_SYM_CLASS_UNION_TAG = 12;
    public static final byte IMAGE_SYM_CLASS_TYPE_DEFINITION = 13;
    public static final byte IMAGE_SYM_CLASS_UNDEFINED_STATIC = 14;
    public static final byte IMAGE_SYM_CLASS_ENUM_TAG = 15;
    public static final byte IMAGE_SYM_CLASS_MEMBER_OF_ENUM = 16;
    public static final byte IMAGE_SYM_CLASS_REGISTER_PARAM = 17;
    public static final byte IMAGE_SYM_CLASS_BIT_FIELD = 18;
    public static final byte IMAGE_SYM_CLASS_FAR_EXTERNAL = 68;
    public static final byte IMAGE_SYM_CLASS_BLOCK = 100;
    public static final byte IMAGE_SYM_CLASS_FUNCTION = 101;
    public static final byte IMAGE_SYM_CLASS_END_OF_STRUCT = 102;
    public static final byte IMAGE_SYM_CLASS_FILE = 103;
    public static final byte IMAGE_SYM_CLASS_SECTION = 104;
    public static final byte IMAGE_SYM_CLASS_WEAK_EXTERNAL = 105;
    private String name;
    private int value;
    private short sectionNumber;
    private short type;
    private byte storageClass;
    private byte numberOfAuxSymbols;
    private DebugCOFFSymbolAux[] auxSymbols;

    public DebugCOFFSymbol(BinaryReader reader, int index, DebugCOFFSymbolTable symbolTable) throws IOException {
        this(reader, index, symbolTable.getStringTableIndex());
    }

    public DebugCOFFSymbol(BinaryReader reader, int index, long stringTableIndex) throws IOException {
        int shortVal = reader.readInt(index);
        if (shortVal != 0) {
            this.name = reader.readAsciiString(index, 8).trim();
            index += 8;
        } else {
            int longVal = reader.readInt(index += 4);
            index += 4;
            if (longVal > 0) {
                this.name = reader.readAsciiString(stringTableIndex + (long)longVal);
            }
        }
        this.value = reader.readInt(index);
        this.sectionNumber = reader.readShort(index += 4);
        this.type = reader.readShort(index += 2);
        this.storageClass = reader.readByte(index += 2);
        this.numberOfAuxSymbols = reader.readByte(++index);
        ++index;
        this.auxSymbols = new DebugCOFFSymbolAux[Conv.byteToInt((byte)this.numberOfAuxSymbols)];
        for (int i = 0; i < this.numberOfAuxSymbols; ++i) {
            this.auxSymbols[i] = new DebugCOFFSymbolAux(reader, index, this);
            index += 18;
        }
    }

    public DebugCOFFSymbolAux[] getAuxiliarySymbols() {
        return this.auxSymbols;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public String getValueAsString() {
        return Integer.toHexString(this.value);
    }

    public int getSectionNumber() {
        return this.sectionNumber;
    }

    public String getSectionNumberAsString() {
        switch (this.sectionNumber) {
            case 0: {
                return "UNDEF";
            }
            case -1: {
                return "ABS";
            }
            case -2: {
                return "DEBUG";
            }
        }
        return Integer.toHexString(this.sectionNumber & 0xFFFF);
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return Integer.toHexString(this.type & 0xFFFF);
    }

    public int getStorageClass() {
        return this.storageClass;
    }

    public String getStorageClassAsString() {
        switch (this.storageClass) {
            case -1: {
                return "END_OF_FUNCTION";
            }
            case 0: {
                return "NULL";
            }
            case 1: {
                return "AUTOMATIC";
            }
            case 2: {
                return "EXTERNAL";
            }
            case 3: {
                return "STATIC";
            }
            case 4: {
                return "REGISTER";
            }
            case 5: {
                return "EXTERNAL_DEF";
            }
            case 6: {
                return "LABEL";
            }
            case 7: {
                return "UNDEFINED_LABEL";
            }
            case 8: {
                return "MEMBER_OF_STRUCT";
            }
            case 9: {
                return "ARGUMENT";
            }
            case 10: {
                return "STRUCT_TAG";
            }
            case 11: {
                return "MEMBER_OF_UNION";
            }
            case 12: {
                return "UNION_TAG";
            }
            case 13: {
                return "TYPE_DEFINITION";
            }
            case 14: {
                return "UNDEFINED_STATIC";
            }
            case 15: {
                return "ENUM_TAG";
            }
            case 16: {
                return "MEMBER_OF_ENUM";
            }
            case 17: {
                return "REGISTER_PARAM";
            }
            case 18: {
                return "BIT_FIELD";
            }
            case 68: {
                return "FAR_EXTERNAL";
            }
            case 100: {
                return "BLOCK";
            }
            case 101: {
                return "FUNCTION";
            }
            case 102: {
                return "END_OF_STRUCT";
            }
            case 103: {
                return "FILE";
            }
            case 104: {
                return "SECTION";
            }
            case 105: {
                return "WEAK_EXTERNAL";
            }
        }
        return "STORAGE_CLASS_" + Integer.toHexString(this.storageClass & 0xFF);
    }

    public int getNumberOfAuxSymbols() {
        return this.numberOfAuxSymbols;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String structureName = StructConverterUtil.parseName(DebugCOFFSymbol.class);
        StructureDataType structure = new StructureDataType(structureName + "_" + this.numberOfAuxSymbols, 0);
        structure.add(STRING, 8, "name", null);
        structure.add(DWORD, "value", null);
        structure.add(WORD, "sectionNumber", null);
        structure.add(WORD, "type", null);
        structure.add(BYTE, "storageClass", null);
        structure.add(BYTE, "numberOfAuxSymbols", null);
        for (DebugCOFFSymbolAux auxSymbol : this.auxSymbols) {
            structure.add(auxSymbol.toDataType());
        }
        return structure;
    }

    public String toString() {
        return String.format("%s section=%d value=0x%x type=0x%x class=0x%x aux=%d", this.name, this.sectionNumber, this.value, this.type, this.storageClass, this.numberOfAuxSymbols);
    }
}

