/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.plugin.core.reloc.ElfRelocationFixupHandler;
import ghidra.app.util.bin.format.elf.relocation.SH_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;

public class ElfSH4RelocationFixupHandler
extends ElfRelocationFixupHandler {
    public ElfSH4RelocationFixupHandler() {
        super(SH_ElfRelocationType.class);
    }

    public boolean processRelocation(Program program, Relocation relocation, Address oldImageBase, Address newImageBase) throws MemoryAccessException, CodeUnitInsertionException {
        if (relocation.getStatus() != Relocation.Status.APPLIED) {
            return false;
        }
        SH_ElfRelocationType type = (SH_ElfRelocationType)this.getRelocationType(relocation.getType());
        if (type == null) {
            return false;
        }
        switch (type) {
            case R_SH_DIR32: 
            case R_SH_REL32: 
            case R_SH_GLOB_DAT: 
            case R_SH_JMP_SLOT: 
            case R_SH_RELATIVE: {
                return this.process32BitRelocation(program, relocation, oldImageBase, newImageBase);
            }
        }
        return false;
    }

    public boolean handlesProgram(Program program) {
        if (!"Executable and Linking Format (ELF)".equals(program.getExecutableFormat())) {
            return false;
        }
        Language language = program.getLanguage();
        if (language.getLanguageDescription().getSize() != 32) {
            return false;
        }
        Processor processor = language.getProcessor();
        return "SuperH4".equals(processor.toString());
    }
}

