/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.catacombae.jparted.lib.fs.FileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.hfs.HFSFileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.hfsplus.HFSPlusFileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.hfsx.HFSXFileSystemHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileSystemMajorType {
    APPLE_MFS,
    APPLE_HFS(HFSFileSystemHandlerFactory.class),
    APPLE_HFS_PLUS(HFSPlusFileSystemHandlerFactory.class),
    APPLE_HFSX(HFSXFileSystemHandlerFactory.class),
    APPLE_UFS,
    APPLE_PRODOS,
    FAT12,
    FAT16,
    FAT32,
    EXFAT,
    NTFS,
    HPFS,
    EXT3,
    REISERFS,
    REISER4,
    XFS,
    JFS,
    ZFS,
    UNKNOWN;

    private final LinkedList<Class<? extends FileSystemHandlerFactory>> factoryClasses = new LinkedList();

    private FileSystemMajorType() {
    }

    private FileSystemMajorType(Class<? extends FileSystemHandlerFactory> factoryClass) {
        this.factoryClasses.add(factoryClass);
    }

    public void addFactoryClass(Class<? extends FileSystemHandlerFactory> factoryClass) {
        this.factoryClasses.addLast(factoryClass);
    }

    public List<Class<? extends FileSystemHandlerFactory>> getFactoryClasses() {
        return new ArrayList<Class<? extends FileSystemHandlerFactory>>(this.factoryClasses);
    }

    public FileSystemHandlerFactory createDefaultHandlerFactory() {
        if (this.factoryClasses.size() == 0) {
            return null;
        }
        Class<? extends FileSystemHandlerFactory> factoryClass = this.factoryClasses.getFirst();
        return FileSystemMajorType.createHandlerFactory(factoryClass);
    }

    public static FileSystemHandlerFactory createHandlerFactory(Class<? extends FileSystemHandlerFactory> factoryClass) {
        try {
            Constructor<? extends FileSystemHandlerFactory> c = factoryClass.getConstructor(new Class[0]);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

