/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseInsert;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class InsertRequest
extends BSimQuery<ResponseInsert> {
    public DescriptionManager manage = new DescriptionManager();
    public String repo_override = null;
    public String path_override = null;
    public ResponseInsert insertresponse;

    public InsertRequest() {
        super("insert");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.insertresponse = new ResponseInsert();
            this.response = this.insertresponse;
        }
    }

    @Override
    public DescriptionManager getDescriptionManager() {
        return this.manage;
    }

    public InsertRequest getLocalStagingCopy() {
        InsertRequest newi = new InsertRequest();
        newi.repo_override = this.repo_override;
        newi.path_override = this.path_override;
        return newi;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.manage.saveXml(fwrite);
        if (this.repo_override != null) {
            fwrite.append("<repository>").append(this.repo_override).append("</repository>\n");
        }
        if (this.path_override != null) {
            fwrite.append("<path>").append(this.path_override).append("</path>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        parser.start(new String[]{this.name});
        this.manage.restoreXml(parser, vectorFactory);
        XmlElement subel = parser.peek();
        while (subel.isStart()) {
            if (subel.getName().equals("repository")) {
                parser.start(new String[]{"repository"});
                this.repo_override = parser.end().getText();
            } else if (subel.getName().equals("path")) {
                parser.start(new String[]{"path"});
                this.path_override = parser.end().getText();
            }
            subel = parser.peek();
        }
        parser.end();
    }
}

