/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBRecord;
import ghidra.program.database.map.AddressMapDB;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;

class ByteMappedSubMemoryBlock
extends SubMemoryBlock {
    private final MemoryMapDB memMap;
    private final Address mappedAddress;
    private final ByteMappingScheme byteMappingScheme;
    private boolean ioPending;

    ByteMappedSubMemoryBlock(MemoryMapDBAdapter adapter, DBRecord record) {
        super(adapter, record);
        this.memMap = adapter.getMemoryMap();
        AddressMapDB addressMap = this.memMap.getAddressMap();
        this.mappedAddress = addressMap.decodeAddress(record.getLongValue(5), false);
        int encodedMappingScheme = record.getIntValue(4);
        this.byteMappingScheme = new ByteMappingScheme(encodedMappingScheme);
    }

    ByteMappingScheme getByteMappingScheme() {
        return this.byteMappingScheme;
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public byte getByte(long offsetInMemBlock) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            Address sourceAddr = this.byteMappingScheme.getMappedSourceAddress(this.mappedAddress, offsetInSubBlock);
            byte by = this.memMap.getByte(sourceAddr);
            return by;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int getBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        if (this.ioPending) {
            new MemoryAccessException("Cyclic Access");
        }
        try {
            this.ioPending = true;
            int n = this.byteMappingScheme.getBytes(this.memMap, this.mappedAddress, offsetInSubBlock, b, off, len);
            return n;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public void putByte(long offsetInMemBlock, byte b) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            Address sourceAddr = this.byteMappingScheme.getMappedSourceAddress(this.mappedAddress, offsetInSubBlock);
            this.memMap.setByte(sourceAddr, b);
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    @Override
    public int putBytes(long offsetInMemBlock, byte[] b, int off, int len) throws MemoryAccessException, IOException {
        long offsetInSubBlock = offsetInMemBlock - this.subBlockOffset;
        long available = this.subBlockLength - offsetInSubBlock;
        len = (int)Math.min((long)len, available);
        try {
            if (this.ioPending) {
                new MemoryAccessException("Cyclic Access");
            }
            this.ioPending = true;
            this.byteMappingScheme.setBytes(this.memMap, this.mappedAddress, offsetInSubBlock, b, off, len);
            int n = len;
            return n;
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException("No memory at address");
        }
        finally {
            this.ioPending = false;
        }
    }

    AddressRange getMappedRange() {
        Address endMappedAddress;
        try {
            endMappedAddress = this.byteMappingScheme.getMappedSourceAddress(this.mappedAddress, this.subBlockLength - 1L);
        }
        catch (AddressOverflowException e) {
            endMappedAddress = this.mappedAddress.getAddressSpace().getMaxAddress();
        }
        return new AddressRangeImpl(this.mappedAddress, endMappedAddress);
    }

    @Override
    protected boolean join(SubMemoryBlock sub2) {
        return false;
    }

    @Override
    protected boolean isMapped() {
        return true;
    }

    @Override
    protected MemoryBlockType getType() {
        return MemoryBlockType.BYTE_MAPPED;
    }

    @Override
    protected SubMemoryBlock split(long memBlockOffset) throws IOException {
        if (!this.byteMappingScheme.isOneToOneMapping()) {
            throw new UnsupportedOperationException("split not supported for byte-mapped block with " + String.valueOf(this.byteMappingScheme));
        }
        int offset = (int)(memBlockOffset - this.subBlockOffset);
        long newLength = this.subBlockLength - (long)offset;
        this.subBlockLength = offset;
        this.record.setLongValue(2, this.subBlockLength);
        this.adapter.updateSubBlockRecord(this.record);
        Address newAddr = this.mappedAddress.add(offset);
        AddressMapDB addressMap = this.adapter.getMemoryMap().getAddressMap();
        long encodedAddr = addressMap.getKey(newAddr, true);
        DBRecord newSubRecord = this.adapter.createSubBlockRecord(0L, 0L, newLength, (byte)1, 0, encodedAddr);
        return new ByteMappedSubMemoryBlock(this.adapter, newSubRecord);
    }

    @Override
    protected String getDescription() {
        return "bytemap[0x%x, 0x%x, %s]".formatted(this.subBlockOffset, this.subBlockLength, this.mappedAddress);
    }
}

