/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionSignatureFieldLocation;

public class FunctionParameterFieldLocation
extends FunctionSignatureFieldLocation {
    private Parameter parameter;
    private int ordinal;

    public FunctionParameterFieldLocation(Program program, Address locationAddr, Address functionAddr, int charOffset, String signature, Parameter parameter) {
        super(program, locationAddr, functionAddr, charOffset, signature);
        this.parameter = parameter;
        this.ordinal = parameter == null ? -1 : parameter.getOrdinal();
    }

    public FunctionParameterFieldLocation() {
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            FunctionParameterFieldLocation other = (FunctionParameterFieldLocation)obj;
            return this.ordinal == other.ordinal;
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", Function Parameter: " + String.valueOf(this.parameter);
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putInt("_FUNCTION_PARAMETER_ORDINAL", this.ordinal);
    }

    @Override
    public void restoreState(Program restoreProgram, SaveState obj) {
        super.restoreState(restoreProgram, obj);
        this.ordinal = obj.getInt("_FUNCTION_PARAMETER_ORDINAL", -1);
        Function function = restoreProgram.getFunctionManager().getFunctionAt(this.functionAddr);
        if (function != null) {
            this.parameter = function.getParameter(this.ordinal);
        }
    }
}

