/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.journal;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import org.prevayler.foundation.Chunk;
import org.prevayler.foundation.DurableInputStream;
import org.prevayler.foundation.DurableOutputStream;
import org.prevayler.foundation.Guided;
import org.prevayler.foundation.StopWatch;
import org.prevayler.foundation.monitor.Monitor;
import org.prevayler.implementation.PrevaylerDirectory;
import org.prevayler.implementation.TransactionGuide;
import org.prevayler.implementation.TransactionTimestamp;
import org.prevayler.implementation.journal.Journal;
import org.prevayler.implementation.publishing.TransactionSubscriber;

public class PersistentJournal
implements Journal {
    private final PrevaylerDirectory _directory;
    private DurableOutputStream _outputJournal;
    private final long _journalSizeThresholdInBytes;
    private final long _journalAgeThresholdInMillis;
    private StopWatch _journalAgeTimer;
    private final boolean _journalDiskSync;
    private long _nextTransaction;
    private boolean _nextTransactionInitialized = false;
    private Monitor _monitor;
    private final String _journalSuffix;

    public PersistentJournal(PrevaylerDirectory directory, long journalSizeThresholdInBytes, long journalAgeThresholdInMillis, boolean journalDiskSync, String journalSuffix, Monitor monitor) throws IOException {
        PrevaylerDirectory.checkValidJournalSuffix(journalSuffix);
        this._monitor = monitor;
        this._directory = directory;
        this._directory.produceDirectory();
        this._journalSizeThresholdInBytes = journalSizeThresholdInBytes;
        this._journalAgeThresholdInMillis = journalAgeThresholdInMillis;
        this._journalDiskSync = journalDiskSync;
        this._journalSuffix = journalSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(TransactionGuide guide) {
        DurableOutputStream myOutputJournal;
        if (!this._nextTransactionInitialized) {
            throw new IllegalStateException("Journal.update() has to be called at least once before Journal.append().");
        }
        DurableOutputStream outputJournalToClose = null;
        guide.startTurn();
        try {
            guide.checkSystemVersion(this._nextTransaction);
            if (!this.isOutputJournalStillValid()) {
                outputJournalToClose = this._outputJournal;
                this._outputJournal = this.createOutputJournal(this._nextTransaction, guide);
                this._journalAgeTimer = StopWatch.start();
            }
            ++this._nextTransaction;
            myOutputJournal = this._outputJournal;
        }
        finally {
            guide.endTurn();
        }
        try {
            myOutputJournal.sync(guide);
        }
        catch (Exception exception) {
            this.abort(exception, this._outputJournal.file(), "writing to", guide);
        }
        guide.startTurn();
        try {
            try {
                if (outputJournalToClose != null) {
                    outputJournalToClose.close();
                }
            }
            catch (Exception exception) {
                this.abort(exception, outputJournalToClose.file(), "closing", guide);
            }
        }
        finally {
            guide.endTurn();
        }
    }

    private boolean isOutputJournalStillValid() {
        return this._outputJournal != null && !this.isOutputJournalTooBig() && !this.isOutputJournalTooOld();
    }

    private boolean isOutputJournalTooOld() {
        return this._journalAgeThresholdInMillis != 0L && this._journalAgeTimer.millisEllapsed() >= this._journalAgeThresholdInMillis;
    }

    private boolean isOutputJournalTooBig() {
        return this._journalSizeThresholdInBytes != 0L && this._outputJournal.file().length() >= this._journalSizeThresholdInBytes;
    }

    private DurableOutputStream createOutputJournal(long transactionNumber, Guided guide) {
        File file = this._directory.journalFile(transactionNumber, this._journalSuffix);
        try {
            return new DurableOutputStream(file, this._journalDiskSync);
        }
        catch (Exception exception) {
            this.abort(exception, file, "creating", guide);
            return null;
        }
    }

    @Override
    public void update(TransactionSubscriber subscriber, long initialTransactionWanted) throws IOException, ClassNotFoundException {
        File initialJournal = this._directory.findInitialJournalFile(initialTransactionWanted);
        if (initialJournal == null) {
            this.initializeNextTransaction(initialTransactionWanted, 1L);
            return;
        }
        long nextTransaction = this.recoverPendingTransactions(subscriber, initialTransactionWanted, initialJournal);
        this.initializeNextTransaction(initialTransactionWanted, nextTransaction);
    }

    private void initializeNextTransaction(long initialTransactionWanted, long nextTransaction) throws IOException {
        if (this._nextTransactionInitialized) {
            if (this._nextTransaction < initialTransactionWanted) {
                throw new IOException("The transaction log has not yet reached transaction " + initialTransactionWanted + ". The last logged transaction was " + (this._nextTransaction - 1L) + ".");
            }
            if (nextTransaction < this._nextTransaction) {
                throw new IOException("Unable to find journal file containing transaction " + nextTransaction + ". Might have been manually deleted.");
            }
            if (nextTransaction > this._nextTransaction) {
                throw new IllegalStateException();
            }
            return;
        }
        this._nextTransactionInitialized = true;
        this._nextTransaction = initialTransactionWanted > nextTransaction ? initialTransactionWanted : nextTransaction;
    }

    private long recoverPendingTransactions(TransactionSubscriber subscriber, long initialTransaction, File initialJournal) throws IOException {
        long recoveringTransaction = PrevaylerDirectory.journalVersion(initialJournal);
        File journal = initialJournal;
        DurableInputStream input = new DurableInputStream(journal, this._monitor);
        while (true) {
            try {
                while (true) {
                    Chunk chunk = input.readChunk();
                    if (recoveringTransaction >= initialTransaction) {
                        if (!journal.getName().endsWith(this._journalSuffix)) {
                            throw new IOException("There are transactions needing to be recovered from " + journal + ", but only " + this._journalSuffix + " files are supported");
                        }
                        TransactionTimestamp entry = TransactionTimestamp.fromChunk(chunk);
                        if (entry.systemVersion() != recoveringTransaction) {
                            throw new IOException("Expected " + recoveringTransaction + " but was " + entry.systemVersion());
                        }
                        subscriber.receive(entry);
                    }
                    ++recoveringTransaction;
                }
            }
            catch (EOFException eof) {
                File nextFile = this._directory.journalFile(recoveringTransaction, this._journalSuffix);
                if (journal.equals(nextFile)) {
                    PrevaylerDirectory.renameUnusedFile(journal);
                }
                if ((journal = nextFile).exists()) {
                    input = new DurableInputStream(journal, this._monitor);
                    continue;
                }
                return recoveringTransaction;
            }
            break;
        }
    }

    private void abort(Exception exception, File journal, String action, Guided guide) {
        guide.abortTurn("All transaction processing is now aborted. An IOException was thrown while " + action + " a .journal file.", exception);
    }

    @Override
    public void close() throws IOException {
        if (this._outputJournal != null) {
            this._outputJournal.close();
        }
    }

    @Override
    public long nextTransaction() {
        if (!this._nextTransactionInitialized) {
            throw new IllegalStateException("update() must be called at least once");
        }
        return this._nextTransaction;
    }
}

