/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal;

import java.util.Optional;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.plugin.management.PluginRequest;
import org.gradle.plugin.management.internal.PluginCoordinates;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.jspecify.annotations.Nullable;

public class DefaultPluginRequest
implements PluginRequestInternal {
    private final PluginId id;
    private final String version;
    private final boolean apply;
    private final Integer lineNumber;
    private final String scriptDisplayName;
    private final ModuleVersionSelector module;
    private final PluginRequest originalRequest;
    private final PluginRequestInternal.Origin origin;
    private final PluginCoordinates alternativeCoordinates;

    public DefaultPluginRequest(PluginId id, boolean apply, PluginRequestInternal.Origin origin, @Nullable String scriptDisplayName, @Nullable Integer lineNumber, @Nullable String version, @Nullable ModuleVersionSelector module, @Nullable PluginRequest originalRequest, @Nullable PluginCoordinates alternativeCoordinates) {
        this.id = id;
        this.version = version;
        this.apply = apply;
        this.lineNumber = lineNumber;
        this.scriptDisplayName = scriptDisplayName;
        this.module = module;
        this.originalRequest = originalRequest;
        this.origin = origin;
        this.alternativeCoordinates = alternativeCoordinates;
    }

    public PluginId getId() {
        return this.id;
    }

    public @Nullable String getVersion() {
        return this.version;
    }

    public @Nullable ModuleVersionSelector getModule() {
        return this.module;
    }

    @Override
    public boolean isApply() {
        return this.apply;
    }

    @Override
    public @Nullable Integer getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public @Nullable String getScriptDisplayName() {
        return this.scriptDisplayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        StringBuilder b = new StringBuilder();
        b.append("[id: '").append(this.id).append("'");
        if (this.version != null) {
            b.append(", version: '").append(this.version).append("'");
        }
        if (this.module != null) {
            b.append(", artifact: '").append(this.module).append("'");
        }
        if (!this.apply) {
            b.append(", apply: false");
        }
        b.append("]");
        return b.toString();
    }

    @Override
    public @Nullable PluginRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @Override
    public PluginRequestInternal.Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Optional<PluginCoordinates> getAlternativeCoordinates() {
        return Optional.ofNullable(this.alternativeCoordinates);
    }
}

