/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.BytesUrlUtils;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class GeneratedClassLoader
extends URLClassLoader {
    private ClassFileFactory factory;

    public GeneratedClassLoader(@NotNull ClassFileFactory factory, ClassLoader parentClassLoader, URL ... urls) {
        if (factory == null) {
            GeneratedClassLoader.$$$reportNull$$$0(0);
        }
        super(urls, parentClassLoader);
        this.factory = factory;
    }

    @NotNull
    public ClassFileFactory getClassFileFactory() {
        ClassFileFactory classFileFactory = this.factory;
        if (classFileFactory == null) {
            GeneratedClassLoader.$$$reportNull$$$0(1);
        }
        return classFileFactory;
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        OutputFile outputFile = this.factory.get(name2);
        if (outputFile != null) {
            return new ByteArrayInputStream(outputFile.asByteArray());
        }
        return super.getResourceAsStream(name2);
    }

    @Override
    public Enumeration<URL> findResources(String name2) throws IOException {
        Enumeration<URL> fromParent = super.findResources(name2);
        URL url = this.createFakeURLForResource(name2);
        if (url == null) {
            return fromParent;
        }
        List fromMe = Collections.singletonList(url);
        List result2 = fromParent.hasMoreElements() ? CollectionsKt.plus(fromMe, Collections.list(fromParent)) : fromMe;
        return Collections.enumeration(result2);
    }

    @Override
    public URL findResource(String name2) {
        URL url = this.createFakeURLForResource(name2);
        return url != null ? url : super.findResource(name2);
    }

    @Nullable
    private URL createFakeURLForResource(@NotNull String name2) {
        if (name2 == null) {
            GeneratedClassLoader.$$$reportNull$$$0(2);
        }
        try {
            OutputFile outputFile = this.factory.get(name2);
            return outputFile == null ? null : BytesUrlUtils.createBytesUrl(outputFile.asByteArray());
        }
        catch (IOException e2) {
            throw ExceptionUtilsKt.rethrow(e2);
        }
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        String classFilePath;
        OutputFile outputFile;
        if (name2 == null) {
            GeneratedClassLoader.$$$reportNull$$$0(3);
        }
        if ((outputFile = this.factory.get(classFilePath = name2.replace('.', '/') + ".class")) != null) {
            String pkgName;
            byte[] bytes = outputFile.asByteArray();
            int lastDot = name2.lastIndexOf(46);
            if (lastDot >= 0 && this.getPackage(pkgName = name2.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, new Manifest(), null);
            }
            Class<?> clazz = this.defineClass(name2, bytes, 0, bytes.length);
            if (clazz == null) {
                GeneratedClassLoader.$$$reportNull$$$0(4);
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name2);
        if (clazz == null) {
            GeneratedClassLoader.$$$reportNull$$$0(5);
        }
        return clazz;
    }

    public void dispose() {
        this.factory = null;
    }

    @NotNull
    public List<OutputFile> getAllGeneratedFiles() {
        List<OutputFile> list = this.factory.asList();
        if (list == null) {
            GeneratedClassLoader.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/GeneratedClassLoader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/GeneratedClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFileFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGeneratedFiles";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFakeURLForResource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

