/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.AccessorIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.CommonIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.CompositeSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileLocalIdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.FileSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.LocalSignature;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "", "libraryFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "irInterner", "Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;)V", "loadSignatureProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IdSignature;", "index", "", "signatureCache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "deserializeIdSignature", "deserializePublicIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/CommonIdSignature;", "deserializeAccessorIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/AccessorIdSignature;", "deserializeFileLocalIdSignature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileLocalIdSignature;", "deserializeScopeLocalIdSignature", "deserializeCompositeIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/CompositeSignature;", "deserializeLocalIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LocalSignature;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/LocalSignature;", "deserializeFileIdSignature", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/FileSignature;", "deserializeSignatureData", "signatureToIndexMapping", "", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n382#2,7:115\n1#3:122\n1267#4,4:123\n*S KotlinDebug\n*F\n+ 1 IdSignatureDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer\n*L\n32#1:115,7\n112#1:123,4\n*E\n"})
public final class IdSignatureDeserializer {
    @NotNull
    private final IrLibraryFile libraryFile;
    @Nullable
    private final IdSignature.FileSignature fileSignature;
    @NotNull
    private final IrInterningService irInterner;
    @NotNull
    private final HashMap<Integer, org.jetbrains.kotlin.ir.util.IdSignature> signatureCache;

    public IdSignatureDeserializer(@NotNull IrLibraryFile libraryFile, @Nullable IdSignature.FileSignature fileSignature, @NotNull IrInterningService irInterner) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Intrinsics.checkNotNullParameter((Object)irInterner, (String)"irInterner");
        this.libraryFile = libraryFile;
        this.fileSignature = fileSignature;
        this.irInterner = irInterner;
        this.signatureCache = new HashMap();
    }

    private final IdSignature loadSignatureProto(int index) {
        return this.libraryFile.signature(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.util.IdSignature deserializeIdSignature(int index) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.signatureCache;
        Integer key$iv = index;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature sigData = this.loadSignatureProto(index);
            org.jetbrains.kotlin.ir.util.IdSignature answer$iv = this.deserializeSignatureData(sigData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (org.jetbrains.kotlin.ir.util.IdSignature)object;
    }

    private final IdSignature.CommonSignature deserializePublicIdSignature(CommonIdSignature proto) {
        String string;
        Long memberId;
        List<Integer> list = proto.getPackageFqNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPackageFqNameList(...)");
        String pkg = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list));
        List<Integer> list2 = proto.getDeclarationFqNameList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeclarationFqNameList(...)");
        String cls = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list2));
        Long l2 = memberId = proto.hasMemberUniqId() ? Long.valueOf(proto.getMemberUniqId()) : null;
        if (proto.hasDebugInfo()) {
            String string2 = this.libraryFile.debugInfo(proto.getDebugInfo());
            if (string2 != null) {
                String string3 = string2;
                IrInterningService irInterningService = this.irInterner;
                String p0 = string3;
                boolean bl = false;
                string = irInterningService.string(p0);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String description = string;
        return new IdSignature.CommonSignature(pkg, cls, memberId, proto.getFlags(), description);
    }

    private final IdSignature.AccessorSignature deserializeAccessorIdSignature(AccessorIdSignature proto) {
        String string;
        org.jetbrains.kotlin.ir.util.IdSignature propertySignature = this.deserializeIdSignature(proto.getPropertySignature());
        if (!(propertySignature instanceof IdSignature.CommonSignature)) {
            boolean $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = false;
            String $i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22 = "For public accessor corresponding property supposed to be public as well";
            throw new IllegalArgumentException($i$a$-require-IdSignatureDeserializer$deserializeAccessorIdSignature$22.toString());
        }
        String name2 = this.libraryFile.string(proto.getName());
        long hash = proto.getAccessorHashId();
        long mask = proto.getFlags();
        if (proto.hasDebugInfo()) {
            String string2 = this.libraryFile.debugInfo(proto.getDebugInfo());
            if (string2 != null) {
                String string3 = string2;
                IrInterningService irInterningService = this.irInterner;
                String p0 = string3;
                boolean bl = false;
                string = irInterningService.string(p0);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        String description = string;
        String declarationFqName = this.irInterner.string(((IdSignature.CommonSignature)propertySignature).getDeclarationFqName() + '.' + name2);
        IdSignature.CommonSignature accessorSignature = new IdSignature.CommonSignature(((IdSignature.CommonSignature)propertySignature).getPackageFqName(), declarationFqName, hash, mask, description);
        return new IdSignature.AccessorSignature(propertySignature, accessorSignature);
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeFileLocalIdSignature(FileLocalIdSignature proto) {
        return new IdSignature.FileLocalSignature(this.deserializeIdSignature(proto.getContainer()), proto.getLocalId());
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeScopeLocalIdSignature(int proto) {
        return new IdSignature.ScopeLocalDeclaration(proto);
    }

    private final IdSignature.CompositeSignature deserializeCompositeIdSignature(CompositeSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature containerSig = this.deserializeIdSignature(proto.getContainerSig());
        org.jetbrains.kotlin.ir.util.IdSignature innerSig = this.deserializeIdSignature(proto.getInnerSig());
        return new IdSignature.CompositeSignature(containerSig, innerSig);
    }

    private final IdSignature.LocalSignature deserializeLocalIdSignature(LocalSignature proto) {
        List<Integer> list = proto.getLocalFqNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLocalFqNameList(...)");
        String localFqn = this.irInterner.string(IrFileDeserializerKt.deserializeFqName(this.libraryFile, list));
        Long localHash = proto.hasLocalHash() ? Long.valueOf(proto.getLocalHash()) : null;
        return new IdSignature.LocalSignature(localFqn, localHash);
    }

    private final IdSignature.FileSignature deserializeFileIdSignature(FileSignature proto) {
        IdSignature.FileSignature fileSignature = this.fileSignature;
        if (fileSignature == null) {
            throw new IllegalStateException("Provide file symbol".toString());
        }
        return fileSignature;
    }

    private final org.jetbrains.kotlin.ir.util.IdSignature deserializeSignatureData(IdSignature proto) {
        org.jetbrains.kotlin.ir.util.IdSignature idSignature;
        IdSignature.IdSigCase idSigCase = proto.getIdSigCase();
        switch (idSigCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[idSigCase.ordinal()]) {
            case 1: {
                CommonIdSignature commonIdSignature = proto.getPublicSig();
                Intrinsics.checkNotNullExpressionValue((Object)commonIdSignature, (String)"getPublicSig(...)");
                idSignature = this.deserializePublicIdSignature(commonIdSignature);
                break;
            }
            case 2: {
                AccessorIdSignature accessorIdSignature = proto.getAccessorSig();
                Intrinsics.checkNotNullExpressionValue((Object)accessorIdSignature, (String)"getAccessorSig(...)");
                idSignature = this.deserializeAccessorIdSignature(accessorIdSignature);
                break;
            }
            case 3: {
                FileLocalIdSignature fileLocalIdSignature = proto.getPrivateSig();
                Intrinsics.checkNotNullExpressionValue((Object)fileLocalIdSignature, (String)"getPrivateSig(...)");
                idSignature = this.deserializeFileLocalIdSignature(fileLocalIdSignature);
                break;
            }
            case 4: {
                idSignature = this.deserializeScopeLocalIdSignature(proto.getScopedLocalSig());
                break;
            }
            case 5: {
                CompositeSignature compositeSignature = proto.getCompositeSig();
                Intrinsics.checkNotNullExpressionValue((Object)compositeSignature, (String)"getCompositeSig(...)");
                idSignature = this.deserializeCompositeIdSignature(compositeSignature);
                break;
            }
            case 6: {
                LocalSignature localSignature = proto.getLocalSig();
                Intrinsics.checkNotNullExpressionValue((Object)localSignature, (String)"getLocalSig(...)");
                idSignature = this.deserializeLocalIdSignature(localSignature);
                break;
            }
            case 7: {
                FileSignature fileSignature = proto.getFileSig();
                Intrinsics.checkNotNullExpressionValue((Object)fileSignature, (String)"getFileSig(...)");
                idSignature = this.deserializeFileIdSignature(fileSignature);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected IdSignature kind: " + proto.getIdSigCase()).toString());
            }
        }
        return idSignature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<org.jetbrains.kotlin.ir.util.IdSignature, Integer> signatureToIndexMapping() {
        void var2_2;
        void $this$associateTo$iv;
        if (this.signatureCache.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Set<Map.Entry<Integer, org.jetbrains.kotlin.ir.util.IdSignature>> set = this.signatureCache.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable iterable = set;
        Map destination$iv = CollectionsKt.newHashMapWithExpectedSize(this.signatureCache.size());
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getValue(), it.getKey());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return var2_2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IdSignature.IdSigCase.values().length];
            try {
                nArray[IdSignature.IdSigCase.PUBLIC_SIG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.ACCESSOR_SIG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.PRIVATE_SIG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.SCOPED_LOCAL_SIG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.COMPOSITE_SIG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.LOCAL_SIG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IdSignature.IdSigCase.FILE_SIG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

