/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.collections.DirectoryWalker;
import org.gradle.api.internal.file.collections.PathVisitor;
import org.gradle.api.specs.Spec;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.jspecify.annotations.Nullable;

public class ReproducibleDirectoryWalker
implements DirectoryWalker {
    private static final Comparator<PathWithAttributes> FILES_FIRST = Comparator.comparing(PathWithAttributes::isDirectory).thenComparing(p -> ((PathWithAttributes)p).path.toString());
    private final FileSystem fileSystem;

    public ReproducibleDirectoryWalker(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public void walkDir(Path rootDir, RelativePath rootPath, FileVisitor visitor, Spec<? super FileTreeElement> spec, AtomicBoolean stopFlag, boolean postfix) {
        PathVisitor pathVisitor = new PathVisitor(spec, postfix, visitor, stopFlag, rootPath, this.fileSystem);
        ReproducibleDirectoryWalker.visit(ReproducibleDirectoryWalker.toPathWithAttributes(rootDir), pathVisitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileVisitResult visit(PathWithAttributes pathWithAttributes, PathVisitor pathVisitor) {
        if (pathWithAttributes.exception != null) {
            return pathVisitor.visitFileFailed(pathWithAttributes.path, pathWithAttributes.exception);
        }
        Path path = pathWithAttributes.path;
        BasicFileAttributes attrs = (BasicFileAttributes)Preconditions.checkNotNull((Object)pathWithAttributes.attributes);
        if (!attrs.isDirectory()) return pathVisitor.visitFile(path, attrs);
        FileVisitResult fvr = pathVisitor.preVisitDirectory(path, attrs);
        if (fvr == FileVisitResult.SKIP_SUBTREE) return fvr;
        if (fvr == FileVisitResult.TERMINATE) {
            return fvr;
        }
        IOException exception = null;
        try (Stream<Path> fileStream = Files.list(path);){
            PathWithAttributes child;
            FileVisitResult childResult;
            Iterable files = () -> fileStream.map(ReproducibleDirectoryWalker::toPathWithAttributes).sorted(FILES_FIRST).iterator();
            Iterator iterator = files.iterator();
            do {
                if (!iterator.hasNext()) return pathVisitor.postVisitDirectory(path, exception);
            } while ((childResult = ReproducibleDirectoryWalker.visit(child = (PathWithAttributes)iterator.next(), pathVisitor)) != FileVisitResult.TERMINATE);
            FileVisitResult fileVisitResult = childResult;
            return fileVisitResult;
        }
        catch (IOException e) {
            exception = e;
        }
        return pathVisitor.postVisitDirectory(path, exception);
    }

    private static PathWithAttributes toPathWithAttributes(Path path) {
        try {
            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return new PathWithAttributes(path, attributes, null);
        }
        catch (IOException ignored) {
            try {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                return new PathWithAttributes(path, attributes, null);
            }
            catch (IOException e) {
                return new PathWithAttributes(path, null, e);
            }
        }
    }

    private static class PathWithAttributes {
        private final Path path;
        private final @Nullable BasicFileAttributes attributes;
        private final @Nullable IOException exception;

        public PathWithAttributes(Path path, @Nullable BasicFileAttributes attrs, @Nullable IOException exception) {
            this.path = path;
            this.attributes = attrs;
            this.exception = exception;
        }

        public boolean isDirectory() {
            return this.attributes != null && this.attributes.isDirectory();
        }
    }
}

