/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.models.DynamicClassException;
import org.hibernate.models.internal.ClassDetailsSupport;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.AbstractAnnotationTarget;
import org.hibernate.models.internal.dynamic.DynamicFieldDetails;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.serial.spi.SerialClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class DynamicClassDetails
extends AbstractAnnotationTarget
implements ClassDetailsSupport {
    private final String name;
    private final String className;
    private final boolean isAbstract;
    private final ClassDetails superClass;
    private final TypeDetails genericSuperType;
    private List<FieldDetails> fields;
    private List<MethodDetails> methods;
    private Class<?> javaType;

    public DynamicClassDetails(String name, ModelsContext modelsContext) {
        this(name, null, null, modelsContext);
    }

    public DynamicClassDetails(String name, ClassDetails superClass, TypeDetails genericSuperType, ModelsContext modelsContext) {
        this(name, null, false, superClass, genericSuperType, modelsContext);
    }

    public DynamicClassDetails(String name, String className, boolean isAbstract, ClassDetails superClass, TypeDetails genericSuperType, ModelsContext modelsContext) {
        this(name, className, null, isAbstract, superClass, genericSuperType, modelsContext);
    }

    public DynamicClassDetails(String name, String className, Class<?> javaType, boolean isAbstract, ClassDetails superClass, TypeDetails genericSuperType, ModelsContext modelsContext) {
        super(modelsContext);
        this.name = name;
        this.className = className;
        this.isAbstract = isAbstract;
        this.superClass = superClass;
        this.genericSuperType = genericSuperType;
        this.javaType = javaType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public ClassDetails getSuperClass() {
        return this.superClass;
    }

    @Override
    public TypeDetails getGenericSuperType() {
        return this.genericSuperType;
    }

    @Override
    public List<TypeDetails> getImplementedInterfaces() {
        return null;
    }

    @Override
    public List<TypeVariableDetails> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public boolean isImplementor(Class<?> checkType) {
        return !StringHelper.isEmpty(this.className) && checkType.isAssignableFrom(this.javaType);
    }

    @Override
    public List<FieldDetails> getFields() {
        if (this.fields == null) {
            return Collections.emptyList();
        }
        return this.fields;
    }

    @Override
    public void addField(FieldDetails fieldDetails) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDetails>();
        }
        this.fields.add(fieldDetails);
    }

    @Override
    public List<MethodDetails> getMethods() {
        if (this.methods == null) {
            return Collections.emptyList();
        }
        return this.methods;
    }

    @Override
    public List<RecordComponentDetails> getRecordComponents() {
        return Collections.emptyList();
    }

    @Override
    public void addMethod(MethodDetails methodDetails) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodDetails>();
        }
        this.methods.add(methodDetails);
    }

    public DynamicFieldDetails applyAttribute(String name, ClassDetails type, boolean isArray, boolean isPlural, ModelsContext context) {
        return this.applyAttribute(name, new ClassTypeDetailsImpl(type, TypeDetails.Kind.CLASS), isArray, isPlural, context);
    }

    public DynamicFieldDetails applyAttribute(String name, TypeDetails type, boolean isArray, boolean isPlural, ModelsContext context) {
        DynamicFieldDetails attribute = new DynamicFieldDetails(name, type, this, -5337, isArray, isPlural, context);
        this.addField(attribute);
        return attribute;
    }

    @Override
    public <X> Class<X> toJavaClass() {
        return this.toJavaClass(this.getModelContext().getClassLoading(), this.getModelContext());
    }

    @Override
    public <X> Class<X> toJavaClass(ClassLoading classLoading, ModelsContext modelContext) {
        if (this.javaType == null) {
            if (this.className == null) {
                throw new DynamicClassException("ClassDetails (name=" + this.name + ") did not specify a class-name");
            }
            this.javaType = this.getModelContext().getClassLoading().classForName(this.className);
        }
        return this.javaType;
    }

    public String toString() {
        return "DynamicClassDetails(" + this.name + " (" + this.className + "))";
    }

    @Override
    public SerialClassDetails toStorableForm() {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

