/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation.dsl;

import java.util.Collections;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.script.Script;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.opensearch.data.type.OpenSearchTextType;
import org.opensearch.sql.opensearch.storage.script.CompoundedScriptEngine;
import org.opensearch.sql.opensearch.storage.serde.ExpressionSerializer;
import org.opensearch.sql.opensearch.storage.serde.SerializationWrapper;

public class AggregationBuilderHelper {
    private final ExpressionSerializer serializer;

    public <T> T build(Expression expression, Function<String, T> fieldBuilder, Function<Script, T> scriptBuilder) {
        if (expression instanceof ReferenceExpression) {
            String fieldName = ((ReferenceExpression)expression).getAttr();
            return fieldBuilder.apply(OpenSearchTextType.convertTextToKeyword(fieldName, expression.type()));
        }
        if (expression instanceof FunctionExpression || expression instanceof LiteralExpression) {
            return scriptBuilder.apply(new Script(Script.DEFAULT_SCRIPT_TYPE, "opensearch_compounded_script", SerializationWrapper.wrapWithLangType(CompoundedScriptEngine.ScriptEngineType.V2, this.serializer.serialize(expression)), Collections.emptyMap()));
        }
        throw new IllegalStateException(String.format("metric aggregation doesn't support expression %s", expression));
    }

    @Generated
    public AggregationBuilderHelper(ExpressionSerializer serializer) {
        this.serializer = serializer;
    }
}

