/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.TimeUnit;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.HealthResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class HealthRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, HealthRequest> {
    @Nullable
    private final TimeUnit time;
    @Nullable
    private final Boolean ts;
    public static final Endpoint<HealthRequest, HealthResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HealthRequest, HealthResponse>(request -> "GET", request -> "/_cat/health", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthResponse._DESERIALIZER);

    private HealthRequest(Builder builder) {
        super(builder);
        this.time = builder.time;
        this.ts = builder.ts;
    }

    public static HealthRequest of(Function<Builder, ObjectBuilder<HealthRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Nullable
    public final Boolean ts() {
        return this.ts;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.time != null) {
            params.put("time", this.time.jsonValue());
        }
        if (this.ts != null) {
            params.put("ts", String.valueOf(this.ts));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.time);
        result = 31 * result + Objects.hashCode(this.ts);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthRequest other = (HealthRequest)o;
        return Objects.equals(this.time, other.time) && Objects.equals(this.ts, other.ts);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, HealthRequest> {
        @Nullable
        private TimeUnit time;
        @Nullable
        private Boolean ts;

        public Builder() {
        }

        private Builder(HealthRequest o) {
            super(o);
            this.time = o.time;
            this.ts = o.ts;
        }

        private Builder(Builder o) {
            super(o);
            this.time = o.time;
            this.ts = o.ts;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Nonnull
        public final Builder ts(@Nullable Boolean value) {
            this.ts = value;
            return this;
        }

        @Override
        @Nonnull
        public HealthRequest build() {
            this._checkSingleUse();
            return new HealthRequest(this);
        }
    }
}

