/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.hot_threads;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class HotThread
implements PlainJsonSerializable {
    private final List<String> hosts;
    private final String nodeId;
    private final String nodeName;
    private final List<String> threads;
    public static final JsonpDeserializer<HotThread> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HotThread::setupHotThreadDeserializer);

    private HotThread(Builder builder) {
        this.hosts = ApiTypeHelper.unmodifiableRequired(builder.hosts, (Object)this, "hosts");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.nodeName = ApiTypeHelper.requireNonNull(builder.nodeName, this, "nodeName");
        this.threads = ApiTypeHelper.unmodifiableRequired(builder.threads, (Object)this, "threads");
    }

    public static HotThread of(Function<Builder, ObjectBuilder<HotThread>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> hosts() {
        return this.hosts;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final List<String> threads() {
        return this.threads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.hosts)) {
            generator.writeKey("hosts");
            generator.writeStartArray();
            for (String item0 : this.hosts) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        if (ApiTypeHelper.isDefined(this.threads)) {
            generator.writeKey("threads");
            generator.writeStartArray();
            for (String item0 : this.threads) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupHotThreadDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hosts, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "hosts");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name");
        op.add(Builder::threads, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "threads");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HotThread> {
        private List<String> hosts;
        private String nodeId;
        private String nodeName;
        private List<String> threads;

        public final Builder hosts(List<String> list) {
            this.hosts = Builder._listAddAll(this.hosts, list);
            return this;
        }

        public final Builder hosts(String value, String ... values) {
            this.hosts = Builder._listAdd(this.hosts, value, values);
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public final Builder threads(List<String> list) {
            this.threads = Builder._listAddAll(this.threads, list);
            return this;
        }

        public final Builder threads(String value, String ... values) {
            this.threads = Builder._listAdd(this.threads, value, values);
            return this;
        }

        @Override
        public HotThread build() {
            this._checkSingleUse();
            return new HotThread(this);
        }
    }
}

