-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Filipino names

-- References
-- Wikipedia: Filipino names - https://en.wikipedia.org/wiki/Filipino_name
-- https://github.com/Ninble/name-census-top-100 (GPL-3.0)

local CultureName = require './common'

local male = {
    "Aaron",
    "Adrian",
    "Albert",
    "Alejandro",
    "Alex",
    "Allan",
    "Alvin",
    "Andrew",
    "Angel",
    "Angelo",
    "Anthony",
    "Antonio",
    "Brian",
    "Bryan",
    "Carl",
    "Carlo",
    "Carlos",
    "Charles",
    "Chris",
    "Christian",
    "Christopher",
    "Cj",
    "Dan",
    "Daniel",
    "Dave",
    "David",
    "Dennis",
    "Don",
    "Edward",
    "Efren",
    "Eric",
    "Francis",
    "Gabriel",
    "Ian",
    "Ivan",
    "Jake",
    "James",
    "Jan",
    "Jason",
    "Javier",
    "Jay",
    "Jayson",
    "Jean",
    "Jeff",
    "Jeffrey",
    "Jen",
    "Jerome",
    "Jesús",
    "Joan",
    "Joel",
    "Joey",
    "John",
    "John-Paul",
    "Jonathan",
    "José",
    "Joseph",
    "Josh",
    "Joshua",
    "Juan",
    "Julius",
    "Justin",
    "Karl",
    "Ken",
    "Kenneth",
    "Kevin",
    "King",
    "Kyle",
    "Leo",
    "Luis",
    "Manuel",
    "Marc",
    "Marco",
    "Mark",
    "Mark-Anthony",
    "Martín",
    "Marvin",
    "Michael",
    "Miguel",
    "Mike",
    "Neil",
    "Pablo",
    "Paolo",
    "Patrick",
    "Paul",
    "Prince",
    "Ralph",
    "Raymond",
    "Richard",
    "Robert",
    "Ron",
    "Ronald",
    "Ryan",
    "Sam",
    "Shane",
    "Toni",
    "Victor",
    "Vince",
    "Vincent",
}

local female = {
    "Abby",
    "Aira",
    "Alyssa",
    "Ana",
    "Andrea",
    "Angela",
    "Angelica",
    "Ann",
    "Anna",
    "Anne",
    "April",
    "Arlene",
    "Ashley",
    "Bea",
    "Bianca",
    "Camille",
    "Carla",
    "Carmen",
    "Catherine",
    "Charlene",
    "Charmaine",
    "Cherry",
    "Christine",
    "Claire",
    "Cristina",
    "Danica",
    "Diana",
    "Diane",
    "Dianne",
    "Donna",
    "Elaine",
    "Ella",
    "Erica",
    "Erika",
    "Grace",
    "Hannah",
    "Hazel",
    "Irene",
    "Irish",
    "Ivy",
    "Jade",
    "Jane",
    "Janine",
    "Jasmine",
    "Jennifer",
    "Jenny",
    "Jessa",
    "Jessica",
    "Joanna",
    "Joy",
    "Joyce",
    "Julia",
    "Justine",
    "Karen",
    "Kate",
    "Katherine",
    "Kathleen",
    "Katrina",
    "Kaye",
    "Kim",
    "Kimberly",
    "Kristine",
    "Laura",
    "Lovely",
    "Mae",
    "Maria",
    "Maricar",
    "Marie",
    "Mariel",
    "Marjorie",
    "Marta",
    "Mary",
    "Mary-Ann",
    "Mary-Grace",
    "Mary-Joy",
    "Mary-Rose",
    "May",
    "Mia",
    "Michelle",
    "Monica",
    "Nicole",
    "Nikki",
    "Nina",
    "Patricia",
    "Paula",
    "Pauline",
    "Princess",
    "Queen",
    "Rachel",
    "Rachelle",
    "Rhea",
    "Rochelle",
    "Rose",
    "Samantha",
    "Sarah",
    "Sheila",
    "Shiela",
    "Stephanie",
    "Trisha",
    "Vanessa",
}

local surname = {
    "Abrenica",
    "Aguilar",
    "Aguinaldo",
    "Alcantara",
    "Alvarez",
    "Angeles",
    "Ann",
    "Anne",
    "Aquino",
    "Barbin",
    "Bartolome",
    "Bautista",
    "Bernardo",
    "Cabrera",
    "Calalang",
    "Cariaso",
    "Castillo",
    "Castro",
    "Chan",
    "Chua",
    "Concepcion",
    "Corpuz",
    "Cortez",
    "Cuenco",
    "Cruz",
    "David",
    "Davide",
    "Dayot",
    "De Guzman",
    "De Leon",
    "Diaz",
    "Dimaculangan",
    "Dizon",
    "Domagoso",
    "Domingo",
    "Dy",
    "Enriquez",
    "Escueta",
    "Evangelista",
    "Fernandez",
    "Ferrer",
    "Flores",
    "Fonacier",
    "Francisco",
    "Galang",
    "Garcia",
    "Go",
    "Gomez",
    "Gonzales",
    "Gonzalez",
    "Gosiengfiao",
    "Grace",
    "Gutierrez",
    "Halili",
    "Hernandez",
    "Hizon",
    "Ignacio",
    "Jane",
    "Jaranilla",
    "Javier",
    "Jimenez",
    "John",
    "Joy",
    "Kim",
    "Lastimosa",
    "Lauzon",
    "Lee",
    "Lim",
    "Lopez",
    "Macapagal",
    "Mae",
    "Magbanua",
    "Magdangal",
    "Maliksi",
    "Manalo",
    "Manuel",
    "Mariano",
    "Marie",
    "Marquez",
    "Martin",
    "Martínez",
    "May",
    "Medina",
    "Mendoza",
    "Mercado",
    "Miranda",
    "Morales",
    "Moreno",
    "Muñoz",
    "Navarro",
    "Nicole",
    "Ocampo",
    "Ong",
    "Ortiz",
    "Padilla",
    "Pagulayan",
    "Panganiban",
    "Pascual",
    "Perez",
    "Pineda",
    "Puyat",
    "Ramirez",
    "Ramos",
    "Recto",
    "Reyes",
    "Rivera",
    "Rodríguez",
    "Romero",
    "Romualdez",
    "Rosales",
    "Rose",
    "Ruiz",
    "Salazar",
    "Salvador",
    "Sanchez",
    "Santiago",
    "Santos",
    "Sarmiento",
    "Singson",
    "Soriano",
    "Suarez",
    "Sumangil",
    "Sy",
    "Tan",
    "Tiangco",
    "Tinio",
    "Tolentino",
    "Torres",
    "Umali",
    "Untalan",
    "Uy",
    "Valdez",
    "Velasco",
    "Villanueva",
    "Yu",
    "Zapanta",
}

local Filipino = CultureName.New({
    male = male,
    female = female,
    surname = surname,
    name = "Filipino",
    code = "fil", -- ISO 639-2 code for Filipino
    replace = { -- Filipino uses some Spanish letters with accents
        ['ñ'] = 'n', ['Ñ'] = 'N',
    }
})

return Filipino
