-- Copyright © 2008-2025 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

-- Sources:
-- https://no.wikipedia.org/wiki/Liste_over_norske_etternavn_p%C3%A5_A
-- https://www.telen.no/nyheter/nyheter/typisk-norsk-a-hete/s/2-2.3402-1.7805434
-- https://www.ssb.no/navn
-- https://www.ssb.no/a/navn/historisk-utvikling-av-guttenavn/
-- https://www.ssb.no/a/navn/historisk-utvikling-av-jentenavn/

local CultureName = require './common'

local male = {
	'Adrian',
	'Aksel',
	'Alexander',
	'Anders',
	'Andreas',
	'Arne',
	'Bjørn',
	'Daniel',
	'Einar',
	'Elias',
	'Emil',
	'Erik',
	'Erling',
	'Espen',
	'Filip',
	'Frode',
	'Geir',
	'Gunnar',
	'Hans',
	'Harald',
	'Henrik',
	'Håkon',
	'Isak',
	'Jakob',
	'Jan',
	'Joakim',
	'Johan',
	'Johannes',
	'John',
	'Jonas',
	'Karl',
	'Kjell',
	'Knut',
	'Kristian',
	'Kristoffer',
	'Kåre',
	'Lars',
	'Leif',
	'Liam',
	'Lucas',
	'Magnus',
	'Marius',
	'Markus',
	'Martin',
	'Mathias',
	'Morten',
	'Nils',
	'Noah',
	'Odd',
	'Olaf',
	'Olav',
	'Ole',
	'Oliver',
	'Oskar',
	'Peder',
	'Per',
	'Rolf',
	'Rune',
	'Sander',
	'Sebastian',
	'Sigurd',
	'Stian',
	'Svein',
	'Sverre',
	'Terje',
	'Thomas',
	'Tobias',
	'Tor',
	'Trond',
	'William',
	'Øyvind',
}

local female = {
	'Anette',
	'Anita',
	'Ann',
	'Anna',
	'Anne',
	'Aslaug',
	'Astrid',
	'Bente',
	'Berit',
	'Bjørg',
	'Borghild',
	'Camilla',
	'Christina',
	'Elin',
	'Elisabeth',
	'Ella',
	'Else',
	'Emilie',
	'Emma',
	'Eva',
	'Gerd',
	'Grethe',
	'Gudrun',
	'Hanna',
	'Hege',
	'Heidi',
	'Helene',
	'Helga',
	'Hilde',
	'Ida',
	'Inga',
	'Ingeborg',
	'Inger',
	'Ingrid',
	'Jenny',
	'Johanne',
	'Julie',
	'Karen',
	'Kari',
	'Karoline',
	'Katrine',
	'Kristin',
	'Kristine',
	'Leah',
	'Lene',
	'Linda',
	'Line',
	'Linn',
	'Linnea',
	'Liv',
	'Maja',
	'Malin',
	'Margit',
	'Maria',
	'Marianne',
	'Marie',
	'Marit',
	'Marta',
	'Marte',
	'Mary',
	'Mona',
	'Monica',
	'Nina',
	'Nora',
	'Olga',
	'Olivia',
	'Ragna',
	'Ragnhild',
	'Randi',
	'Ruth',
	'Sara',
	'Signe',
	'Sigrid',
	'Silje',
	'Sofia',
	'Sofie',
	'Solveig',
	'Stine',
	'Thea',
	'Tone',
	'Torill',
	'Tove',
	'Turid',
	'Wenche',
	'Vilde',
	'Åse',
}

local surname = {
	'Aamodt',
	'Aas',
	'Aase',
	'Aasen',
	'Abrahamsen',
	'Amundsen',
	'Andersen',
	'Andersson',
	'Andreassen',
	'Andresen',
	'Antonsen',
	'Arnesen',
	'Arntsen',
	'Arntzen',
	'Aune',
	'Bakke',
	'Bakken',
	'Berg',
	'Berge',
	'Berger',
	'Berntsen',
	'Birkeland',
	'Bjerke',
	'Bjørnstad',
	'Borge',
	'Borgen',
	'Breivik',
	'Brekke',
	'Bråten',
	'Bråthen',
	'Bye',
	'Bø',
	'Bøe',
	'Børresen',
	'Carlsen',
	'Christensen',
	'Christiansen',
	'Dahl',
	'Dahle',
	'Dale',
	'Dalen',
	'Danielsen',
	'Edvardsen',
	'Egeland',
	'Eide',
	'Eikeland',
	'Eilertsen',
	'Eliassen',
	'Ellefsen',
	'Ellingsen',
	'Engebretsen',
	'Engen',
	'Enger',
	'Eriksen',
	'Evensen',
	'Fjeld',
	'Foss',
	'Fosse',
	'Fossum',
	'Fredriksen',
	'Gabrielsen',
	'Gjerde',
	'Gulbrandsen',
	'Gundersen',
	'Gustavsen',
	'Haaland',
	'Haga',
	'Hagen',
	'Halvorsen',
	'Hammer',
	'Hamre',
	'Hansen',
	'Hanssen',
	'Haug',
	'Haugan',
	'Hauge',
	'Haugen',
	'Haugland',
	'Helgesen',
	'Helland',
	'Helle',
	'Henriksen',
	'Hermansen',
	'Hoel',
	'Hoff',
	'Hole',
	'Holen',
	'Holm',
	'Holmen',
	'Hovland',
	'Håland',
	'Ingebrigtsen',
	'Isaksen',
	'Iversen',
	'Jacobsen',
	'Jakobsen',
	'Jansen',
	'Jensen',
	'Jenssen',
	'Johannesen',
	'Johannessen',
	'Johansen',
	'Johansson',
	'Johnsen',
	'Jonassen',
	'Jørgensen',
	'Karlsen',
	'Khan',
	'Kleven',
	'Knudsen',
	'Knutsen',
	'Kolstad',
	'Kristensen',
	'Kristiansen',
	'Kristoffersen',
	'Kvam',
	'Kvamme',
	'Langeland',
	'Larsen',
	'Lie',
	'Lien',
	'Lind',
	'Lorentzen',
	'Ludvigsen',
	'Lund',
	'Lunde',
	'Løken',
	'Løkken',
	'Madsen',
	'Magnussen',
	'Markussen',
	'Martinsen',
	'Mathisen',
	'Mikalsen',
	'Mikkelsen',
	'Moe',
	'Moen',
	'Monsen',
	'Mortensen',
	'Myhre',
	'Myklebust',
	'Myrvang',
	'Mæland',
	'Møller',
	'Nguyen',
	'Nielsen',
	'Nikolaisen',
	'Nilsen',
	'Nilssen',
	'Nordby',
	'Nordli',
	'Nygaard',
	'Nygård',
	'Næss',
	'Olsen',
	'Ottesen',
	'Paulsen',
	'Pedersen',
	'Petersen',
	'Pettersen',
	'Røed',
	'Rønningen',
	'Samuelsen',
	'Sand',
	'Sandberg',
	'Sande',
	'Sandnes',
	'Skoglund',
	'Sletten',
	'Solbakken',
	'Solem',
	'Solli',
	'Solvang',
	'Steen',
	'Stene',
	'Stensrud',
	'Stokke',
	'Sunde',
	'Sveen',
	'Syversen',
	'Sætre',
	'Sørlie',
	'Teigen',
	'Thoresen',
	'Tollefsen',
	'Torgersen',
	'Torp',
	'Tran',
	'Tvedt',
	'Tønnessen',
	'Walaker',
	'Wang',
	'Wiik',
	'Viken',
	'Wilhelmsen',
	'Wold',
	'Ødegaard',
	'Ødegård',
	'Øien',
	'Østby',
}

local Norwegian = CultureName.New({
	male = male,
	female = female,
	surname = surname,
	name = "Norwegian",
	code = "nb",
	replace = {
		["æ"] = "a", ["Æ"] = "A",
		["ø"] = "o", ["Ø"] = "O",
		["å"] = "a", ["Å"] = "A",
	}
})

return Norwegian
