/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.agent.extension;

import com.intellij.platform.diagnostic.telemetry.agent.extension.Configuration;
import com.intellij.platform.diagnostic.telemetry.agent.extension.JsonUtil;
import io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

class JsonSpanExporter
implements SpanExporter {
    private static final Logger LOG = Logger.getLogger(JsonSpanExporter.class.getName());
    @NotNull
    private final Path targetFile;

    private JsonSpanExporter(@NotNull ConfigProperties config) {
        if (config == null) {
            JsonSpanExporter.$$$reportNull$$$0(0);
        }
        this.targetFile = JsonSpanExporter.getTargetFile(config);
    }

    public CompletableResultCode export(@NotNull Collection<SpanData> spans) {
        if (spans == null) {
            JsonSpanExporter.$$$reportNull$$$0(1);
        }
        return JsonSpanExporter.write(this.targetFile, stream -> TraceRequestMarshaler.create((Collection)spans).writeJsonTo(stream));
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    @NotNull
    private static CompletableResultCode write(@NotNull Path targetFile, @NotNull BufferOperation<OutputStream> consumer) {
        if (targetFile == null) {
            JsonSpanExporter.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            JsonSpanExporter.$$$reportNull$$$0(3);
        }
        try {
            String json = JsonSpanExporter.captureIntoBuffer(consumer);
            JsonSpanExporter.appendJsonToFile(targetFile, json);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, String.format("Unable to flush an opentelemetry dump into %s: %s", targetFile, e.getMessage()));
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            if (completableResultCode == null) {
                JsonSpanExporter.$$$reportNull$$$0(4);
            }
            return completableResultCode;
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        if (completableResultCode == null) {
            JsonSpanExporter.$$$reportNull$$$0(5);
        }
        return completableResultCode;
    }

    @NotNull
    public static SpanProcessor createProcessor(@NotNull ConfigProperties config) {
        BatchSpanProcessor processor;
        if (config == null) {
            JsonSpanExporter.$$$reportNull$$$0(6);
        }
        JsonSpanExporter exporter = new JsonSpanExporter(config);
        BatchSpanProcessor batchSpanProcessor = processor = BatchSpanProcessor.builder((SpanExporter)exporter).setExporterTimeout(Duration.ofMinutes(1L)).setMaxQueueSize(4096).setMaxExportBatchSize(2048).build();
        if (batchSpanProcessor == null) {
            JsonSpanExporter.$$$reportNull$$$0(7);
        }
        return batchSpanProcessor;
    }

    @NotNull
    private static String captureIntoBuffer(@NotNull BufferOperation<OutputStream> consumer) throws Exception {
        if (consumer == null) {
            JsonSpanExporter.$$$reportNull$$$0(8);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        consumer.execute(buffer);
        String string = buffer.toString(StandardCharsets.UTF_8.name());
        String string2 = string;
        if (string2 == null) {
            JsonSpanExporter.$$$reportNull$$$0(9);
        }
        return string2;
        finally {
            buffer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendJsonToFile(@NotNull Path pathToFile, @NotNull String json) throws IOException {
        if (pathToFile == null) {
            JsonSpanExporter.$$$reportNull$$$0(10);
        }
        if (json == null) {
            JsonSpanExporter.$$$reportNull$$$0(11);
        }
        if (!Files.exists(pathToFile, new LinkOption[0])) {
            JsonSpanExporter.ensureParentExists(pathToFile);
            Files.write(pathToFile, json.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            LOG.info(String.format("Telemetry will be written into %s", pathToFile));
            return;
        }
        String content = JsonUtil.merge(String.join((CharSequence)" ", Files.readAllLines(pathToFile)), json);
        Path temp = pathToFile.getParent().resolve("temp_" + System.currentTimeMillis() + ".json");
        try {
            Files.write(temp, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            Files.move(temp, pathToFile, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    private static void ensureParentExists(@NotNull Path path) throws IOException {
        Path parent;
        if (path == null) {
            JsonSpanExporter.$$$reportNull$$$0(12);
        }
        if (Files.exists(parent = path.getParent(), new LinkOption[0])) {
            return;
        }
        Files.createDirectories(parent, new FileAttribute[0]);
    }

    @NotNull
    private static Path getTargetFile(@NotNull ConfigProperties config) {
        if (config == null) {
            JsonSpanExporter.$$$reportNull$$$0(13);
        }
        Path root = Configuration.getTargetJsonLocation(config);
        String serviceName = Configuration.getServiceName(config);
        String outputFileName = serviceName + "-telemetry-" + System.currentTimeMillis() + ".json";
        Path path = root.resolve(outputFileName);
        if (path == null) {
            JsonSpanExporter.$$$reportNull$$$0(14);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/diagnostic/telemetry/agent/extension/JsonSpanExporter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/diagnostic/telemetry/agent/extension/JsonSpanExporter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "captureIntoBuffer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "captureIntoBuffer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendJsonToFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureParentExists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface BufferOperation<T> {
        public void execute(T var1) throws IOException;
    }
}

