/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.metrics.reporters.SolrJmxReporter;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.DOMConfigNode;
import org.apache.solr.util.DataConfigNode;
import org.apache.solr.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SolrXmlConfig {
    public static final String ZK_HOST = "zkHost";
    public static final String SOLR_XML_FILE = "solr.xml";
    public static final String SOLR_DATA_HOME = "solr.data.home";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern COMMA_SEPARATED_PATTERN = Pattern.compile("\\s*,\\s*");

    public static Properties wrapAndSetZkHostFromSysPropIfNeeded(Properties props) {
        if (null != props && StrUtils.isNotNullOrEmpty((String)props.getProperty(ZK_HOST))) {
            return props;
        }
        Properties results = null == props ? new Properties() : new Properties(props);
        String sysprop = System.getProperty(ZK_HOST);
        if (StrUtils.isNotNullOrEmpty((String)sysprop)) {
            results.setProperty(ZK_HOST, sysprop);
        }
        return results;
    }

    public static NodeConfig fromConfig(Path solrHome, Properties substituteProperties, boolean fromZookeeper, ConfigNode root, SolrResourceLoader loader) {
        UpdateShardHandlerConfig updateConfig;
        NamedList<Object> entries;
        String nodeName;
        SolrXmlConfig.checkForIllegalConfig(root);
        assert (!fromZookeeper || null != substituteProperties && null != substituteProperties.getProperty(ZK_HOST));
        String defaultZkHost = SolrXmlConfig.wrapAndSetZkHostFromSysPropIfNeeded(substituteProperties).getProperty(ZK_HOST);
        CloudConfig cloudConfig = null;
        UpdateShardHandlerConfig deprecatedUpdateConfig = null;
        if (root.get("solrcloud").exists()) {
            NamedList<Object> cloudSection = SolrXmlConfig.readNodeListAsNamedList(root.get("solrcloud"), "<solrcloud>");
            deprecatedUpdateConfig = SolrXmlConfig.loadUpdateConfig(cloudSection, false);
            cloudConfig = SolrXmlConfig.fillSolrCloudSection(cloudSection, defaultZkHost);
        }
        if (StrUtils.isNullOrEmpty((String)(nodeName = (String)(entries = SolrXmlConfig.readNodeListAsNamedList(root, "<solr>")).remove("nodeName"))) && cloudConfig != null) {
            nodeName = cloudConfig.getHost();
        }
        Map<String, String> coreAdminHandlerActions = SolrXmlConfig.readNodeListAsNamedList(root.get("coreAdminHandlerActions"), "<coreAdminHandlerActions>").asShallowMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> item.getValue().toString()));
        if (deprecatedUpdateConfig == null) {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(root.get("updateshardhandler"), "<updateshardhandler>"), true);
        } else {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(root.get("updateshardhandler"), "<updateshardhandler>"), false);
            if (updateConfig != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "UpdateShardHandler configuration defined twice in solr.xml");
            }
            updateConfig = deprecatedUpdateConfig;
        }
        NodeConfig.NodeConfigBuilder configBuilder = new NodeConfig.NodeConfigBuilder(nodeName, solrHome);
        configBuilder.setSolrResourceLoader(loader);
        configBuilder.setUpdateShardHandlerConfig(updateConfig);
        configBuilder.setShardHandlerFactoryConfig(SolrXmlConfig.getPluginInfo(root.get("shardHandlerFactory")));
        configBuilder.setTracerConfig(SolrXmlConfig.getPluginInfo(root.get("tracerConfig")));
        configBuilder.setLogWatcherConfig(SolrXmlConfig.loadLogWatcherConfig(root.get("logging")));
        configBuilder.setSolrProperties(SolrXmlConfig.loadProperties(root, substituteProperties));
        if (cloudConfig != null) {
            configBuilder.setCloudConfig(cloudConfig);
        }
        configBuilder.setBackupRepositoryPlugins(SolrXmlConfig.getBackupRepositoryPluginInfos(root.get("backup").getAll("repository")));
        configBuilder.setClusterPlugins(SolrXmlConfig.getClusterPlugins(loader, root));
        configBuilder.setHiddenSysProps(SolrXmlConfig.getHiddenSysProps(root.get("metrics")));
        configBuilder.setMetricsConfig(SolrXmlConfig.getMetricsConfig(root.get("metrics")));
        configBuilder.setCachesConfig(SolrXmlConfig.getCachesConfig(loader, root.get("caches")));
        configBuilder.setFromZookeeper(fromZookeeper);
        configBuilder.setDefaultZkHost(defaultZkHost);
        configBuilder.setCoreAdminHandlerActions(coreAdminHandlerActions);
        return SolrXmlConfig.fillSolrSection(configBuilder, root);
    }

    public static NodeConfig fromFile(Path solrHome, Path configFile, Properties substituteProps) {
        NodeConfig nodeConfig;
        block12: {
            if (!Files.exists(configFile, new LinkOption[0])) {
                if (Boolean.getBoolean("solr.solrxml.required")) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + String.valueOf(configFile.getParent()) + " cannot start Solr");
                }
                log.info("solr.xml not found in SOLR_HOME, using built-in default");
                String solrInstallDir = System.getProperty("solr.install.dir");
                if (solrInstallDir == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find default solr.xml file due to missing solr.install.dir");
                }
                configFile = Path.of(solrInstallDir, new String[0]).resolve("server").resolve("solr").resolve(SOLR_XML_FILE);
            }
            log.info("Loading solr.xml from {}", (Object)configFile);
            InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                nodeConfig = SolrXmlConfig.fromInputStream(solrHome, inputStream, substituteProps);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SolrException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)exc);
                }
            }
            inputStream.close();
        }
        return nodeConfig;
    }

    public static NodeConfig fromString(Path solrHome, String xml) {
        return SolrXmlConfig.fromInputStream(solrHome, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), new Properties());
    }

    public static NodeConfig fromInputStream(Path solrHome, InputStream is, Properties substituteProps) {
        return SolrXmlConfig.fromInputStream(solrHome, is, substituteProps, false);
    }

    public static NodeConfig fromInputStream(Path solrHome, InputStream is, Properties substituteProps, boolean fromZookeeper) {
        NodeConfig nodeConfig;
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        if (substituteProps == null) {
            substituteProps = new Properties();
        }
        byte[] buf = is.readAllBytes();
        ByteArrayInputStream dup = new ByteArrayInputStream(buf);
        try {
            XmlConfigFile config = new XmlConfigFile(loader, null, new InputSource(dup), null, substituteProps);
            nodeConfig = SolrXmlConfig.fromConfig(solrHome, substituteProps, fromZookeeper, new DataConfigNode(new DOMConfigNode(config.getDocument().getDocumentElement())), loader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dup.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SolrException exc) {
                throw exc;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        dup.close();
        return nodeConfig;
    }

    public static NodeConfig fromSolrHome(Path solrHome, Properties substituteProps) {
        return SolrXmlConfig.fromFile(solrHome, solrHome.resolve(SOLR_XML_FILE), substituteProps);
    }

    private static void checkForIllegalConfig(ConfigNode root) {
        SolrXmlConfig.failIfFound(root.attr("coreLoadThreads"), "solr/@coreLoadThreads");
        SolrXmlConfig.failIfFound(root.attr("persistent"), "solr/@persistent");
        SolrXmlConfig.failIfFound(root.attr("sharedLib"), "solr/@sharedLib");
        SolrXmlConfig.failIfFound(root.attr(ZK_HOST), "solr/@zkHost");
        SolrXmlConfig.failIfFound(root.attr(ZK_HOST), "solr/@zkHost");
        SolrXmlConfig.failIfFound(root.get("cores").exists() ? "" : null, "solr/cores");
        SolrXmlConfig.assertSingleInstance(root.getAll("solrcloud"), "solrcloud");
        SolrXmlConfig.assertSingleInstance(root.getAll("logging"), "logging");
        SolrXmlConfig.assertSingleInstance(root.get("logging").getAll("watcher"), "logging/watcher");
        SolrXmlConfig.assertSingleInstance(root.getAll("backup"), "backup");
        SolrXmlConfig.assertSingleInstance(root.getAll("coreAdminHandlerActions"), "coreAdminHandlerActions");
    }

    private static void assertSingleInstance(List<ConfigNode> l, String section) {
        if (l.size() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple instances of " + section + " section found in solr.xml");
        }
    }

    private static void failIfFound(String val, String xPath) {
        if (val != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + "\n. Please upgrade your solr.xml: https://solr.apache.org/guide/solr/latest/configuration-guide/configuring-solr-xml.html");
        }
    }

    private static Properties loadProperties(ConfigNode cfg, Properties substituteProperties) {
        Properties properties = new Properties(substituteProperties);
        cfg.forEachChild(it -> {
            if (it.name().equals("property")) {
                properties.setProperty(it.attr("name"), it.attr("value"));
            }
            return Boolean.TRUE;
        });
        return properties;
    }

    private static NamedList<Object> readNodeListAsNamedList(ConfigNode cfg, String section) {
        NamedList nl = cfg.childNodesToNamedList();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : nl) {
            if (keys.add((String)entry.getKey())) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section of solr.xml contains duplicated '" + (String)entry.getKey() + "'");
        }
        return nl;
    }

    private static int parseInt(String field, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing '" + field + "', value '" + value + "' cannot be parsed as int");
        }
    }

    private static NodeConfig fillSolrSection(NodeConfig.NodeConfigBuilder builder, ConfigNode root) {
        SolrXmlConfig.forEachNamedListEntry(root, it -> {
            if (it.name().equals("null")) {
                return;
            }
            try {
                switch (it.attr("name")) {
                    case "adminHandler": {
                        builder.setCoreAdminHandlerClass(it.txt());
                        break;
                    }
                    case "collectionsHandler": {
                        builder.setCollectionsAdminHandlerClass(it.txt());
                        break;
                    }
                    case "healthCheckHandler": {
                        builder.setHealthCheckHandlerClass(it.txt());
                        break;
                    }
                    case "infoHandler": {
                        builder.setInfoHandlerClass(it.txt());
                        break;
                    }
                    case "configSetsHandler": {
                        builder.setConfigSetsHandlerClass(it.txt());
                        break;
                    }
                    case "configSetService": {
                        builder.setConfigSetServiceClass(it.txt());
                        break;
                    }
                    case "coresLocator": {
                        builder.setCoresLocatorClass(it.txt());
                        break;
                    }
                    case "coreSorter": {
                        builder.setCoreSorterClass(it.txt());
                        break;
                    }
                    case "coreRootDirectory": {
                        builder.setCoreRootDirectory(it.txt());
                        break;
                    }
                    case "solrDataHome": {
                        builder.setSolrDataHome(it.txt());
                        break;
                    }
                    case "maxBooleanClauses": {
                        builder.setBooleanQueryMaxClauseCount(it.intVal(-1));
                        break;
                    }
                    case "managementPath": {
                        builder.setManagementPath(it.txt());
                        break;
                    }
                    case "sharedLib": {
                        builder.setSharedLibDirectory(it.txt());
                        break;
                    }
                    case "modules": {
                        builder.setModules(it.txt());
                        break;
                    }
                    case "hiddenSysProps": {
                        builder.setHiddenSysProps(it.txt());
                        break;
                    }
                    case "allowPaths": {
                        builder.setAllowPaths(SolrXmlConfig.separatePaths(it.txt()));
                        break;
                    }
                    case "hideStackTrace": {
                        builder.setHideStackTrace(it.boolVal(false));
                        break;
                    }
                    case "configSetBaseDir": {
                        builder.setConfigSetBaseDirectory(it.txt());
                        break;
                    }
                    case "shareSchema": {
                        builder.setUseSchemaCache(it.boolVal(false));
                        break;
                    }
                    case "coreLoadThreads": {
                        builder.setCoreLoadThreads(it.intVal(-1));
                        break;
                    }
                    case "replayUpdatesThreads": {
                        builder.setReplayUpdatesThreads(it.intVal(-1));
                        break;
                    }
                    case "indexSearcherExecutorThreads": {
                        builder.setIndexSearcherExecutorThreads(it.intVal(-1));
                        break;
                    }
                    case "transientCacheSize": {
                        log.warn("solr.xml transientCacheSize -- transient cores is deprecated");
                        builder.setTransientCacheSize(it.intVal(-1));
                        break;
                    }
                    case "allowUrls": {
                        builder.setAllowUrls(SolrXmlConfig.separateStrings(it.txt()));
                        break;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration value in solr.xml: " + it.attr("name"));
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing '" + it.attr("name") + "', value '" + it.txt() + "' cannot be parsed");
            }
        });
        return builder.build();
    }

    private static List<String> separateStrings(String commaSeparatedString) {
        if (StrUtils.isNullOrEmpty((String)commaSeparatedString)) {
            return Collections.emptyList();
        }
        return Arrays.asList(COMMA_SEPARATED_PATTERN.split(commaSeparatedString));
    }

    private static Set<String> separateStringsToSet(String commaSeparatedString) {
        if (StrUtils.isNullOrEmpty((String)commaSeparatedString)) {
            return Collections.emptySet();
        }
        return Set.of(COMMA_SEPARATED_PATTERN.split(commaSeparatedString));
    }

    private static Set<Path> separatePaths(String commaSeparatedString) {
        if (StrUtils.isNullOrEmpty((String)commaSeparatedString)) {
            return Collections.emptySet();
        }
        String[] pathStrings = COMMA_SEPARATED_PATTERN.split(commaSeparatedString);
        SolrPaths.AllowPathBuilder allowPathBuilder = new SolrPaths.AllowPathBuilder();
        for (String p : pathStrings) {
            allowPathBuilder.addPath(p);
        }
        return allowPathBuilder.build();
    }

    private static UpdateShardHandlerConfig loadUpdateConfig(NamedList<Object> nl, boolean alwaysDefine) {
        Object mrt;
        Object mns;
        Object dct;
        Object dst;
        Object mucph;
        if (nl == null && !alwaysDefine) {
            return null;
        }
        if (nl == null) {
            return UpdateShardHandlerConfig.DEFAULT;
        }
        boolean defined = false;
        int maxUpdateConnections = 100000;
        int maxUpdateConnectionsPerHost = 100000;
        int distributedSocketTimeout = 600000;
        int distributedConnectionTimeout = 60000;
        String metricNameStrategy = "queryLessURLAndMethod";
        int maxRecoveryThreads = -1;
        Object muc = nl.remove("maxUpdateConnections");
        if (muc != null) {
            maxUpdateConnections = SolrXmlConfig.parseInt("maxUpdateConnections", muc.toString());
            defined = true;
        }
        if ((mucph = nl.remove("maxUpdateConnectionsPerHost")) != null) {
            maxUpdateConnectionsPerHost = SolrXmlConfig.parseInt("maxUpdateConnectionsPerHost", mucph.toString());
            defined = true;
        }
        if ((dst = nl.remove("distribUpdateSoTimeout")) != null) {
            distributedSocketTimeout = SolrXmlConfig.parseInt("distribUpdateSoTimeout", dst.toString());
            defined = true;
        }
        if ((dct = nl.remove("distribUpdateConnTimeout")) != null) {
            distributedConnectionTimeout = SolrXmlConfig.parseInt("distribUpdateConnTimeout", dct.toString());
            defined = true;
        }
        if ((mns = nl.remove("metricNameStrategy")) != null) {
            metricNameStrategy = mns.toString();
            defined = true;
        }
        if ((mrt = nl.remove("maxRecoveryThreads")) != null) {
            maxRecoveryThreads = SolrXmlConfig.parseInt("maxRecoveryThreads", mrt.toString());
            defined = true;
        }
        if (!defined && !alwaysDefine) {
            return null;
        }
        return new UpdateShardHandlerConfig(maxUpdateConnections, maxUpdateConnectionsPerHost, distributedSocketTimeout, distributedConnectionTimeout, metricNameStrategy, maxRecoveryThreads);
    }

    private static String removeValue(NamedList<Object> nl, String key) {
        Object value = nl.remove(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String required(String section, String key, String value) {
        if (value != null) {
            return value;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section missing required entry '" + key + "'");
    }

    private static CloudConfig fillSolrCloudSection(NamedList<Object> nl, String defaultZkHost) {
        int hostPort = SolrXmlConfig.parseInt("hostPort", SolrXmlConfig.required("solrcloud", "hostPort", SolrXmlConfig.removeValue(nl, "hostPort")));
        if (hostPort <= 0) {
            hostPort = SolrXmlConfig.parseInt("jetty.port", System.getProperty("jetty.port", "8983"));
        }
        String hostName = SolrXmlConfig.required("solrcloud", "host", SolrXmlConfig.removeValue(nl, "host"));
        String hostContext = SolrXmlConfig.required("solrcloud", "hostContext", SolrXmlConfig.removeValue(nl, "hostContext"));
        CloudConfig.CloudConfigBuilder builder = new CloudConfig.CloudConfigBuilder(hostName, hostPort, hostContext);
        builder.setZkHost(defaultZkHost);
        block36: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "leaderVoteWait": {
                    builder.setLeaderVoteWait(SolrXmlConfig.parseInt(name, value));
                    continue block36;
                }
                case "leaderConflictResolveWait": {
                    builder.setLeaderConflictResolveWait(SolrXmlConfig.parseInt(name, value));
                    continue block36;
                }
                case "zkClientTimeout": {
                    builder.setZkClientTimeout(SolrXmlConfig.parseInt(name, value));
                    continue block36;
                }
                case "zkHost": {
                    builder.setZkHost(value);
                    continue block36;
                }
                case "genericCoreNodeNames": {
                    builder.setUseGenericCoreNames(Boolean.parseBoolean(value));
                    continue block36;
                }
                case "zkACLProvider": {
                    builder.setZkACLProviderClass(value);
                    continue block36;
                }
                case "zkCredentialsProvider": {
                    builder.setZkCredentialsProviderClass(value);
                    continue block36;
                }
                case "zkCredentialsInjector": {
                    builder.setZkCredentialsInjectorClass(value);
                    continue block36;
                }
                case "createCollectionWaitTimeTillActive": {
                    builder.setCreateCollectionWaitTimeTillActive(SolrXmlConfig.parseInt(name, value));
                    continue block36;
                }
                case "createCollectionCheckLeaderActive": {
                    builder.setCreateCollectionCheckLeaderActive(Boolean.parseBoolean(value));
                    continue block36;
                }
                case "pkiHandlerPrivateKeyPath": {
                    builder.setPkiHandlerPrivateKeyPath(value);
                    continue block36;
                }
                case "pkiHandlerPublicKeyPath": {
                    builder.setPkiHandlerPublicKeyPath(value);
                    continue block36;
                }
                case "distributedClusterStateUpdates": {
                    builder.setUseDistributedClusterStateUpdates(Boolean.parseBoolean(value));
                    continue block36;
                }
                case "distributedCollectionConfigSetExecution": {
                    builder.setUseDistributedCollectionConfigSetExecution(Boolean.parseBoolean(value));
                    continue block36;
                }
                case "minStateByteLenForCompression": {
                    builder.setMinStateByteLenForCompression(SolrXmlConfig.parseInt(name, value));
                    continue block36;
                }
                case "stateCompressor": {
                    builder.setStateCompressorClass(value);
                    continue block36;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration parameter in <solrcloud> section of solr.xml: " + name);
        }
        return builder.build();
    }

    private static LogWatcherConfig loadLogWatcherConfig(ConfigNode logging) {
        String value;
        String name;
        String loggingClass = null;
        boolean enabled = true;
        int watcherQueueSize = 50;
        String watcherThreshold = null;
        block16: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(logging, "<logging>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "class": {
                    loggingClass = value;
                    continue block16;
                }
                case "enabled": {
                    enabled = Boolean.parseBoolean(value);
                    continue block16;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        block17: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(logging.get("watcher"), "<watcher>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "size": {
                    watcherQueueSize = SolrXmlConfig.parseInt(name, value);
                    continue block17;
                }
                case "threshold": {
                    watcherThreshold = value;
                    continue block17;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        return new LogWatcherConfig(enabled, loggingClass, watcherThreshold, watcherQueueSize);
    }

    static void forEachNamedListEntry(ConfigNode cfg, Consumer<ConfigNode> fun) {
        cfg.forEachChild(it -> {
            if (DOMUtil.NL_TAGS.contains(it.name())) {
                fun.accept((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
    }

    private static PluginInfo[] getBackupRepositoryPluginInfos(List<ConfigNode> cfg) {
        return (PluginInfo[])cfg.stream().map(c -> new PluginInfo((ConfigNode)c, "BackupRepositoryFactory", true, true)).filter(PluginInfo::isEnabled).toArray(PluginInfo[]::new);
    }

    private static PluginInfo[] getClusterPlugins(SolrResourceLoader loader, ConfigNode root) {
        ArrayList<PluginInfo> clusterPlugins = new ArrayList<PluginInfo>();
        Collections.addAll(clusterPlugins, SolrXmlConfig.getClusterSingletonPluginInfos(loader, root.getAll("clusterSingleton")));
        PluginInfo replicaPlacementFactory = SolrXmlConfig.getPluginInfo(root.get("replicaPlacementFactory"));
        if (replicaPlacementFactory != null) {
            if (replicaPlacementFactory.name != null && !replicaPlacementFactory.name.equals(".placement-plugin")) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The replicaPlacementFactory name attribute must be .placement-plugin");
            }
            clusterPlugins.add(replicaPlacementFactory);
        }
        return clusterPlugins.toArray(new PluginInfo[0]);
    }

    private static PluginInfo[] getClusterSingletonPluginInfos(SolrResourceLoader loader, List<ConfigNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return new PluginInfo[0];
        }
        List<PluginInfo> plugins = nodes.stream().map(n -> new PluginInfo((ConfigNode)n, n.name(), true, true)).filter(PluginInfo::isEnabled).collect(Collectors.toList());
        HashSet names = CollectionUtil.newHashSet((int)nodes.size());
        Set duplicateNames = plugins.stream().filter(p -> !names.add(p.name)).map(p -> p.name).collect(Collectors.toSet());
        if (!duplicateNames.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple clusterSingleton sections with name '" + String.join((CharSequence)"', '", duplicateNames) + "' found in solr.xml");
        }
        try {
            plugins.forEach(p -> loader.findClass(p.className, ClusterSingleton.class));
        }
        catch (ClassCastException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "clusterSingleton plugins must implement the interface " + ClusterSingleton.class.getName());
        }
        return plugins.toArray(new PluginInfo[0]);
    }

    private static MetricsConfig getMetricsConfig(ConfigNode metrics) {
        ConfigNode caching;
        MetricsConfig.MetricsConfigBuilder builder = new MetricsConfig.MetricsConfigBuilder();
        boolean enabled = metrics.boolAttr("enabled", true);
        builder.setEnabled(enabled);
        if (!enabled) {
            log.info("Metrics collection is disabled.");
            return builder.build();
        }
        builder.setCounterSupplier(SolrXmlConfig.getPluginInfo(metrics.get("suppliers").get("counter")));
        builder.setMeterSupplier(SolrXmlConfig.getPluginInfo(metrics.get("suppliers").get("meter")));
        builder.setTimerSupplier(SolrXmlConfig.getPluginInfo(metrics.get("suppliers").get("timer")));
        builder.setHistogramSupplier(SolrXmlConfig.getPluginInfo(metrics.get("suppliers").get("histogram")));
        if (metrics.get("missingValues").exists()) {
            NamedList missingValues = metrics.get("missingValues").childNodesToNamedList();
            builder.setNullNumber(SolrXmlConfig.decodeNullValue(missingValues.get("nullNumber")));
            builder.setNotANumber(SolrXmlConfig.decodeNullValue(missingValues.get("notANumber")));
            builder.setNullString(SolrXmlConfig.decodeNullValue(missingValues.get("nullString")));
            builder.setNullObject(SolrXmlConfig.decodeNullValue(missingValues.get("nullObject")));
        }
        if ((caching = metrics.get("solr/metrics/caching")) != null) {
            Object threadsCachingIntervalSeconds = caching.childNodesToNamedList().get("threadsIntervalSeconds");
            builder.setCacheConfig(new MetricsConfig.CacheConfig(threadsCachingIntervalSeconds == null ? null : Integer.valueOf(Integer.parseInt(threadsCachingIntervalSeconds.toString()))));
        }
        PluginInfo[] reporterPlugins = SolrXmlConfig.getMetricReporterPluginInfos(metrics);
        return builder.setMetricReporterPlugins(reporterPlugins).build();
    }

    private static Map<String, CacheConfig> getCachesConfig(SolrResourceLoader loader, ConfigNode caches) {
        Map<String, CacheConfig> ret = CacheConfig.getMultipleConfigs(loader, null, null, caches.getAll("cache"));
        for (CacheConfig c : ret.values()) {
            if (c.getRegenerator() == null) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "node-level caches should not be configured with a regenerator!");
        }
        return Collections.unmodifiableMap(ret);
    }

    private static Object decodeNullValue(Object o) {
        String str;
        if (o instanceof String && !(str = (String)o).isBlank() && (str.startsWith("{") || str.startsWith("["))) {
            try {
                o = Utils.fromJSONString((String)((String)o));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    private static PluginInfo[] getMetricReporterPluginInfos(ConfigNode metrics) {
        ArrayList<PluginInfo> configs = new ArrayList<PluginInfo>();
        boolean hasJmxReporter = false;
        for (ConfigNode node : metrics.getAll("reporter")) {
            PluginInfo info = SolrXmlConfig.getPluginInfo(node);
            if (info == null) continue;
            String clazz = info.className;
            if (clazz != null && clazz.equals(SolrJmxReporter.class.getName())) {
                hasJmxReporter = true;
            }
            configs.add(info);
        }
        MBeanServer mBeanServer = JmxUtil.findFirstMBeanServer();
        if (mBeanServer != null && !hasJmxReporter) {
            log.debug("MBean server found: {}, but no JMX reporters were configured - adding default JMX reporter.", (Object)mBeanServer);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", "default");
            attributes.put("class", SolrJmxReporter.class.getName());
            PluginInfo defaultPlugin = new PluginInfo("reporter", attributes);
            configs.add(defaultPlugin);
        }
        return configs.toArray(new PluginInfo[0]);
    }

    @Deprecated(forRemoval=true, since="9.3")
    private static String getHiddenSysProps(ConfigNode metrics) {
        ConfigNode p = metrics.get("hiddenSysProps");
        if (!p.exists()) {
            return null;
        }
        HashSet props = new HashSet();
        p.forEachChild(it -> {
            if (it.name().equals("str") && StrUtils.isNotNullOrEmpty((String)it.txt())) {
                props.add(Pattern.quote(it.txt()));
            }
            return Boolean.TRUE;
        });
        return String.join((CharSequence)",", props);
    }

    private static PluginInfo getPluginInfo(ConfigNode cfg) {
        if (cfg == null || !cfg.exists()) {
            return null;
        }
        PluginInfo pluginInfo = new PluginInfo(cfg, cfg.name(), false, true);
        return pluginInfo.isEnabled() ? pluginInfo : null;
    }
}

